/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.PluginAction;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;

public class RefactoringContext
implements IRefactoringContext {
    private String source;
    private int start;
    private int end;
    private int caret;
    private IFile file;

    public RefactoringContext(int start, int end, String src) {
        this(start, end, start, src);
    }

    public RefactoringContext(int start, int end, int caret, String src) {
        this.start = start;
        this.end = end;
        this.caret = caret;
        this.source = src;
    }

    public RefactoringContext() {
        this.initEditor();
    }

    public RefactoringContext(IAction action) {
        if (action == null || action instanceof EditorPluginAction) {
            this.initEditor();
        } else {
            this.initOutline(action);
        }
    }

    private void initEditor() {
        RubyEditor editor = (RubyEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        this.start = selection.getOffset();
        this.end = this.start + selection.getLength();
        if (this.end > this.start) {
            --this.end;
        }
        this.caret = editor.getCaretPosition().getOffset();
        this.file = ((IFileEditorInput)editor.getEditorInput()).getFile();
    }

    private void initOutline(IAction action) {
        TreeSelection selection = (TreeSelection)((PluginAction)action).getSelection();
        IMember member = (IMember)selection.toArray()[0];
        try {
            this.start = member.getNameRange().getOffset();
            this.end = this.start + member.getNameRange().getLength();
            this.caret = this.start;
            this.file = (IFile)member.getRubyScript().getResource();
        }
        catch (RubyModelException e) {
            e.printStackTrace();
        }
    }

    public IFile getActiveFile() {
        return this.file;
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public int getStartOffset() {
        return this.start;
    }

    public int getEndOffset() {
        return this.end;
    }

    public String getSource() {
        if (this.source == null) {
            RubyEditor editor = (RubyEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            this.source = editor.getViewer().getDocument().get();
        }
        return this.source;
    }
}

