/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.convertlocaltofield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalToFieldEditProvider
extends ReplaceEditProvider {
    private LocalNodeWrapper localNode;
    private boolean initInConstructor;

    public LocalToFieldEditProvider(LocalNodeWrapper localNode, String newName, boolean isClassField, boolean initInConstructor) {
        super(false);
        this.localNode = localNode;
        this.initInConstructor = initInConstructor;
        newName = String.valueOf(isClassField ? "@@" : "@") + newName;
        ArrayList<LocalNodeWrapper> allLocalNodes = new ArrayList<LocalNodeWrapper>();
        allLocalNodes.add(localNode);
        allLocalNodes.addAll(LocalNodeWrapper.gatherLocalNodes(localNode.getWrappedNode()));
        this.replaceAllNames(allLocalNodes, LocalNodeWrapper.getLocalNodeName(localNode), newName);
    }

    private void replaceAllNames(Collection<LocalNodeWrapper> allLocalNodes, String orgName, String newName) {
        for (LocalNodeWrapper aktNode : allLocalNodes) {
            String aktNodeName = LocalNodeWrapper.getLocalNodeName(aktNode);
            if (!aktNodeName.equals(orgName)) continue;
            this.setNodeName(aktNode, newName);
        }
    }

    private void setNodeName(LocalNodeWrapper localNode, String newName) {
        localNode.setName(newName);
    }

    @Override
    protected int getOffsetLength() {
        if (this.initInConstructor) {
            return this.localNode.getWrappedNode().getPositionIncludingComments().getEndOffset() - this.getOffset(null);
        }
        return this.localNode.getWrappedNode().getPosition().getEndOffset() - this.getOffset(null);
    }

    @Override
    protected Node getEditNode(int offset, String document) {
        if (this.initInConstructor) {
            return this.localNode.getWrappedNode();
        }
        return this.stripComments(this.localNode.getWrappedNode());
    }

    private Node stripComments(Node wrappedNode) {
        wrappedNode.getComments().clear();
        List childs = wrappedNode.childNodes();
        int i = 0;
        while (i < childs.size()) {
            if (childs.get(i) instanceof Node) {
                this.stripComments((Node)childs.get(i));
            }
            ++i;
        }
        return wrappedNode;
    }

    @Override
    protected int getOffset(String document) {
        if (this.initInConstructor) {
            return this.localNode.getWrappedNode().getPositionIncludingComments().getStartOffset();
        }
        return this.localNode.getWrappedNode().getPosition().getStartOffset();
    }
}

