/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.encapsulatefield;

import org.jruby.ast.DefnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.encapsulatefield.EncapsulateFieldConfig;
import org.rubypeople.rdt.refactoring.core.encapsulatefield.Messages;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

public class EncapsulateFieldConditionChecker
extends RefactoringConditionChecker {
    private EncapsulateFieldConfig config;
    private Node rootNode;

    public EncapsulateFieldConditionChecker(EncapsulateFieldConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (EncapsulateFieldConfig)configObj;
        this.rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        this.config.setSelectedInstNode(this.findSelectedInstNode(this.config.getCaretPosition()));
        if (!this.config.hasSelectedInstNode()) {
            return;
        }
        this.config.setSelectedAccessor(this.findSelectedAccessor(this.config.getSelectedInstNode()));
        try {
            this.config.setEnclosingClassNode(SelectionNodeProvider.getSelectedClassNode(this.rootNode, this.config.getCaretPosition()));
        }
        catch (NoClassNodeException noClassNodeException) {}
    }

    private AttrAccessorNodeWrapper findSelectedAccessor(INameNode selectedInstNode) {
        return SelectionNodeProvider.getSelectedAccessorNode(this.rootNode, selectedInstNode);
    }

    private INameNode findSelectedInstNode(int caretPosition) {
        return (INameNode)SelectionNodeProvider.getSelectedNodeOfType(this.rootNode, caretPosition, InstVarNode.class, InstAsgnNode.class, SymbolNode.class);
    }

    public void checkFinalConditions() {
        if (this.config.isWriterGenerationDisabled() && this.config.isReaderGenerationDisabled()) {
            this.addError(Messages.EncapsulateFieldConditionChecker_NothingToRefactor);
        }
        String readerMethodName = this.config.getReaderMethodName();
        String writerMethodName = this.config.getWriterMethodName();
        for (MethodNodeWrapper aktMethodNode : this.config.getEnclosingClassNode().getMethods()) {
            if (aktMethodNode.getName().equals(readerMethodName) && !this.config.isReaderGenerationDisabled()) {
                this.addWarning(String.valueOf(Messages.EncapsulateFieldConditionChecker_MethodWithName) + aktMethodNode.getName() + Messages.EncapsulateFieldConditionChecker_AlreadyExists);
            }
            if (!aktMethodNode.getName().equals(writerMethodName) || this.config.isWriterGenerationDisabled()) continue;
            this.addWarning(String.valueOf(Messages.EncapsulateFieldConditionChecker_MethodWithName) + aktMethodNode.getName() + Messages.EncapsulateFieldConditionChecker_AlreadyExists);
        }
    }

    public void checkInitialConditions() {
        if (!this.config.hasSelectedAccessor() && !this.config.hasSelectedInstNode()) {
            this.addError(Messages.EncapsulateFieldConditionChecker_NoInstanceVariableSelected);
        } else if (this.config.getEnclosingClassNode() == null) {
            this.addError(Messages.EncapsulateFieldConditionChecker_NotInsideAClass);
        } else if (this.selectedNodeIsInstVarNodeAndNotInMethod()) {
            this.addError(Messages.EncapsulateFieldConditionChecker_NotInsideAMethod);
        }
    }

    private boolean selectedNodeIsInstVarNodeAndNotInMethod() {
        Node selectedVarNode = SelectionNodeProvider.getSelectedNodeOfType((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getCaretPosition(), InstVarNode.class, InstAsgnNode.class);
        if (selectedVarNode == null) {
            return false;
        }
        Node enclosingMethod = SelectionNodeProvider.getSelectedNodeOfType((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getCaretPosition(), DefnNode.class);
        return enclosingMethod == null;
    }
}

