/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.encapsulatefield;

import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;

public class EncapsulateFieldConfig
implements IRefactoringConfig {
    private IDocumentProvider docProvider;
    private int caretPosition;
    private boolean readerGenerationDisabled;
    private boolean writerGenerationDisabled;
    private ClassNodeWrapper enclosingClassNode;
    private INameNode selectedInstNode;
    private AttrAccessorNodeWrapper selectedAccessor;

    public EncapsulateFieldConfig(IDocumentProvider docProvider, int caretPosition) {
        this.docProvider = docProvider;
        this.caretPosition = caretPosition;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.docProvider;
    }

    public boolean isReaderGenerationDisabled() {
        return this.readerGenerationDisabled;
    }

    public boolean isWriterGenerationDisabled() {
        return this.writerGenerationDisabled;
    }

    public ClassNodeWrapper getEnclosingClassNode() {
        return this.enclosingClassNode;
    }

    public INameNode getSelectedInstNode() {
        return this.selectedInstNode;
    }

    public AttrAccessorNodeWrapper getSelectedAccessor() {
        return this.selectedAccessor;
    }

    public void setEnclosingClassNode(ClassNodeWrapper enclosingClassNode) {
        this.enclosingClassNode = enclosingClassNode;
    }

    public void setReaderGenerationDisabled(boolean readerGenerationDisabled) {
        this.readerGenerationDisabled = readerGenerationDisabled;
    }

    public void setSelectedAccessor(AttrAccessorNodeWrapper selectedAccessor) {
        this.selectedAccessor = selectedAccessor;
    }

    public void setSelectedInstNode(INameNode selectedInstNode) {
        this.selectedInstNode = selectedInstNode;
    }

    public void setWriterGenerationDisabled(boolean writerGenerationDisabled) {
        this.writerGenerationDisabled = writerGenerationDisabled;
    }

    public boolean hasSelectedInstNode() {
        return this.selectedInstNode != null;
    }

    public boolean hasSelectedAccessor() {
        return this.selectedAccessor != null;
    }

    public String getReaderMethodName() {
        String fieldName = this.getFieldName();
        return fieldName != null ? fieldName : null;
    }

    public String getWriterMethodName() {
        String fieldName = this.getFieldName();
        return fieldName != null ? String.valueOf(fieldName) + '=' : null;
    }

    String getFieldName() {
        if (this.hasSelectedAccessor()) {
            return this.getSelectedAccessor().getAttrName();
        }
        if (this.hasSelectedInstNode()) {
            return this.getSelectedInstNode().getName().substring(1);
        }
        return null;
    }

    public void setDocumentProvider(IDocumentProvider doc) {
        this.docProvider = doc;
    }
}

