/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.encapsulatefield;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CommentNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.encapsulatefield.EncapsulateFieldConfig;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.AfterLastMethodInClassOffsetProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEncapsulator
extends MultiEditProvider {
    private VisibilityNodeWrapper.METHOD_VISIBILITY readerVisibility;
    private VisibilityNodeWrapper.METHOD_VISIBILITY writerVisibility;
    private EncapsulateFieldConfig config;

    public FieldEncapsulator(EncapsulateFieldConfig config) {
        this.config = config;
        this.initVisibilities();
        this.initGenerationFields();
    }

    private void initVisibilities() {
        this.writerVisibility = !this.config.hasSelectedAccessor() || !this.config.getSelectedAccessor().isWriter() ? VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE : VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC;
        this.readerVisibility = !this.config.hasSelectedAccessor() || !this.config.getSelectedAccessor().isReader() ? VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE : VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC;
    }

    private void initGenerationFields() {
        this.config.setReaderGenerationDisabled(this.isReaderGenerationOptional());
        this.config.setWriterGenerationDisabled(this.isWriterGenerationOptional());
    }

    @Override
    public Collection<EditProvider> getEditProviders() {
        ArrayList<EditProvider> providers = new ArrayList<EditProvider>();
        if (!this.config.isReaderGenerationDisabled()) {
            providers.add(this.getInsertEditProvider(false, this.readerVisibility));
        }
        if (!this.config.isWriterGenerationDisabled()) {
            providers.add(this.getInsertEditProvider(true, this.writerVisibility));
        }
        if (this.config.hasSelectedAccessor()) {
            for (FCallNode aktAccessorNode : this.config.getSelectedAccessor().getAccessorNodes()) {
                providers.add(new DeleteEditProvider((Node)aktAccessorNode));
            }
        }
        return providers;
    }

    private InsertEditProvider getInsertEditProvider(final boolean writer, final VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
        return new InsertEditProvider(true){

            protected Node getInsertNode(int offset, String document) {
                boolean needsNewLineAtEndOfBlock = this.lastEditInGroup && !this.isNextLineEmpty(offset, document);
                Node contentNode = FieldEncapsulator.this.createGetterOrSetter(writer, visibility);
                return NodeFactory.createBlockNode(needsNewLineAtEndOfBlock, contentNode);
            }

            protected int getOffset(String document) {
                AfterLastMethodInClassOffsetProvider offsetProvider = new AfterLastMethodInClassOffsetProvider(FieldEncapsulator.this.config.getEnclosingClassNode(), document);
                return offsetProvider.getOffset();
            }
        };
    }

    public String getSelectedFieldName() {
        return this.config.hasSelectedAccessor() ? String.valueOf('@') + this.config.getSelectedAccessor().getAttrName() : this.config.getSelectedInstNode().getName();
    }

    public String getExistingAccessorName() {
        return this.config.hasSelectedAccessor() ? this.config.getSelectedAccessor().getAccessorTypeName() : "none";
    }

    public boolean isWriterGenerationOptional() {
        return this.writerVisibility.equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE);
    }

    public VisibilityNodeWrapper.METHOD_VISIBILITY getWriterVisibility() {
        return this.writerVisibility;
    }

    public boolean isReaderGenerationOptional() {
        return this.readerVisibility.equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE);
    }

    public VisibilityNodeWrapper.METHOD_VISIBILITY getReaderVisibility() {
        return this.readerVisibility;
    }

    public void setWriterDisabled(boolean writerDisabled) {
        this.config.setWriterGenerationDisabled(writerDisabled);
    }

    public void setWriterVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
        this.writerVisibility = visibility;
    }

    public void setReaderVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
        this.readerVisibility = visibility;
    }

    public void setReaderDisabled(boolean readerDisabled) {
        this.config.setReaderGenerationDisabled(readerDisabled);
    }

    protected Node createGetterOrSetter(boolean writer, VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
        Collection<CommentNode> comments = this.getAccessorComments(writer);
        BlockNode getterAndSetter = NodeFactory.createGetterSetter(this.config.getFieldName(), writer, visibility, comments);
        return getterAndSetter;
    }

    private Collection<CommentNode> getAccessorComments(boolean isSetter) {
        ArrayList<CommentNode> matchingComments = new ArrayList<CommentNode>();
        AttrAccessorNodeWrapper accessor = this.config.getSelectedAccessor();
        if (accessor != null) {
            Collection<FCallNode> accessors = accessor.getAccessorNodes();
            for (FCallNode currentAccessor : accessors) {
                if (isSetter && currentAccessor.getName().equals("attr_writer")) {
                    matchingComments.addAll(currentAccessor.getComments());
                    continue;
                }
                if (!isSetter && currentAccessor.getName().equals("attr_reader")) {
                    matchingComments.addAll(currentAccessor.getComments());
                    continue;
                }
                if (!currentAccessor.getName().equals("attr_accessor")) continue;
                matchingComments.addAll(currentAccessor.getComments());
            }
        }
        return this.resetCommentPositions(matchingComments);
    }

    private Collection<CommentNode> resetCommentPositions(ArrayList<CommentNode> comments) {
        ArrayList<CommentNode> resettedComments = new ArrayList<CommentNode>();
        for (CommentNode currentComment : comments) {
            resettedComments.add(new CommentNode((ISourcePosition)new IDESourcePosition("", -1, -1, -1, -1), currentComment.getContent()));
        }
        return resettedComments;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ACCESSOR {
        ATTR_ACCESSOR,
        PROTECTED,
        PUBLIC;

    }
}

