/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractconstant;

import org.jruby.ast.ArrayNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.ZArrayNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.extractconstant.ExtractConstantConfig;

public class ExtractConstantConditionChecker
extends RefactoringConditionChecker {
    private ExtractConstantConfig config;

    public ExtractConstantConditionChecker(IRefactoringConfig config2) {
        super(config2);
    }

    protected void checkInitialConditions() {
        if (!this.existSelectedNodes()) {
            this.addError("There is nothing selected to extract.");
        } else if (!this.isPrimitive()) {
            this.addError("Extracting constant not possible on things other than strings, numbers, hashes or arrays.");
        }
    }

    private boolean isPrimitive() {
        return this.config.getSelectedNodes() instanceof ZArrayNode || this.config.getSelectedNodes() instanceof ArrayNode || this.config.getSelectedNodes() instanceof HashNode || this.config.getSelectedNodes() instanceof FixnumNode || this.config.getSelectedNodes() instanceof BignumNode || this.config.getSelectedNodes() instanceof NilNode || this.config.getSelectedNodes() instanceof TrueNode || this.config.getSelectedNodes() instanceof FalseNode || this.config.getSelectedNodes() instanceof StrNode;
    }

    private boolean existSelectedNodes() {
        return !NodeProvider.isEmptyNode(this.config.getSelectedNodes());
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (ExtractConstantConfig)configObj;
        this.config.init();
        NodeProvider.isEmptyNode(this.config.getSelectedNodes());
    }
}

