/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractconstant;

import org.jruby.ast.BlockNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.SClassNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.extractconstant.ExtractConstantConfig;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.RealClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.SClassNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.AfterNodeOffsetProvider;
import org.rubypeople.rdt.refactoring.offsetprovider.BeforeFirstMethodInClassOffsetProvider;

public class ExtractedConstantDef
extends InsertEditProvider {
    private Node insertAfterNode;
    private ExtractConstantConfig config;

    public ExtractedConstantDef(ExtractConstantConfig config) {
        super(true);
        this.config = config;
        this.insertAfterNode = this.getNodeToInsertAfter(config.getRootNode(), config.getSelection());
        if (this.insertAfterNode == null) {
            this.setInsertType(1);
        }
    }

    private Node getNodeToInsertAfter(Node rootNode, IRefactoringContext selection) {
        Node enclosingClassNode = SelectionNodeProvider.getEnclosingNode(rootNode, selection, ClassNode.class);
        if (enclosingClassNode != null) {
            return enclosingClassNode;
        }
        Node enclosingModuleNode = SelectionNodeProvider.getEnclosingNode(rootNode, selection, ModuleNode.class);
        if (enclosingModuleNode != null) {
            return enclosingModuleNode;
        }
        Node enclosingBlockNode = SelectionNodeProvider.getEnclosingNode(this.config.getRootNode(), this.config.getSelection(), BlockNode.class);
        if (enclosingBlockNode != null) {
            Node firstSelectedNode = this.config.getSelectedNodes();
            if (!firstSelectedNode.childNodes().isEmpty()) {
                firstSelectedNode = (Node)firstSelectedNode.childNodes().toArray()[0];
            }
            return NodeProvider.getNodeBefore(enclosingBlockNode, firstSelectedNode);
        }
        return null;
    }

    protected Node getInsertNode(int offset, String document) {
        return this.config.getConstantDeclNode();
    }

    protected int getOffset(String document) {
        if (this.insertAfterNode == null) {
            return 0;
        }
        if (this.insertAfterNode instanceof ClassNode) {
            return new BeforeFirstMethodInClassOffsetProvider(new RealClassNodeWrapper((Node)((ClassNode)this.insertAfterNode)), this.config.getDocumentProvider().getActiveFileContent()).getOffset();
        }
        if (this.insertAfterNode instanceof SClassNode) {
            return new BeforeFirstMethodInClassOffsetProvider(new SClassNodeWrapper((Node)((SClassNode)this.insertAfterNode), this.config.getRootNode()), this.config.getDocumentProvider().getActiveFileContent()).getOffset();
        }
        if (this.insertAfterNode instanceof ModuleNode) {
            return new BeforeFirstMethodInClassOffsetProvider((ModuleNode)this.insertAfterNode, this.config.getDocumentProvider().getActiveFileContent()).getOffset();
        }
        return new AfterNodeOffsetProvider(this.insertAfterNode, document).getOffset();
    }
}

