/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractmethod;

import org.jruby.ast.CallNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.DefaultFormatHelper;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.rubypeople.rdt.refactoring.core.FormatWithParenthesis;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractMethodConfig;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;

public class ExtractedMethodCall
extends ReplaceEditProvider {
    private final Node rootNode;
    private Node selectedNode;
    private Node methodCallNode;

    public ExtractedMethodCall(Node selectedNode, Node methodCallNode, Node rootNode) {
        super(false);
        this.selectedNode = selectedNode;
        this.methodCallNode = methodCallNode;
        this.rootNode = rootNode;
    }

    public ExtractedMethodCall(ExtractMethodConfig config) {
        this(config.getExtractMethodHelper().getSelectedNodes(), config.getExtractMethodHelper().getMethodCallNode(), config.getRootNode());
    }

    protected int getOffsetLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    private int getStartOffset() {
        return this.getExtendedPosition(this.selectedNode).getStartOffset();
    }

    private int getEndOffset() {
        return this.getExtendedPosition(this.selectedNode).getEndOffset();
    }

    protected Node getEditNode(int offset, String document) {
        return this.methodCallNode;
    }

    protected FormatHelper getFormatHelper() {
        Node bodyNode = this.selectedNode;
        while (bodyNode instanceof NewlineNode) {
            bodyNode = ((NewlineNode)bodyNode).getNextNode();
        }
        if (NodeProvider.findParentNode(this.rootNode, bodyNode) instanceof CallNode) {
            return new FormatWithParenthesis();
        }
        return new DefaultFormatHelper();
    }

    protected int getOffset(String document) {
        return this.getStartOffset();
    }
}

