/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.rubypeople.rdt.refactoring.core.extractconstant.MatchingNodesVisitor;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractMethodConfig;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodCall;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodDef;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodHelper;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiEditProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExtractor
extends MultiEditProvider {
    private ExtractMethodConfig config;
    private boolean replaceAll;

    public MethodExtractor(ExtractMethodConfig config) {
        this.config = config;
    }

    @Override
    protected Collection<EditProvider> getEditProviders() {
        ArrayList<EditProvider> providers = new ArrayList<EditProvider>();
        if (this.replaceAll) {
            Node selection = this.config.getSelectedNodes();
            Node rootNode = this.config.getRootNode();
            MatchingNodesVisitor visitor = new MatchingNodesVisitor(selection, this.config.getDocumentProvider().getActiveFileContent());
            rootNode.accept((NodeVisitor)visitor);
            List<Node> matches = visitor.getMatches();
            for (Node node : matches) {
                providers.add(new ExtractedMethodCall(node, this.config.getExtractMethodHelper().getMethodCallNode(), rootNode));
            }
        } else {
            providers.add(new ExtractedMethodCall(this.config));
        }
        providers.add(new ExtractedMethodDef(this.config));
        return providers;
    }

    public EditProvider getDefEdit() {
        return new ExtractedMethodDef(this.config);
    }

    public void setMethodName(String name) {
        this.config.getHelper().setMethodName(name);
    }

    public ExtractedMethodHelper getExtractedMethod() {
        return this.config.getHelper();
    }

    public void setReplaceAllInstances(boolean selection) {
        this.replaceAll = selection;
    }
}

