/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.formatsource;

import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.core.formatsource.EditableFormatHelper;
import org.rubypeople.rdt.refactoring.core.formatsource.FormatSourceConditionChecker;
import org.rubypeople.rdt.refactoring.core.formatsource.FormatSourceConfig;
import org.rubypeople.rdt.refactoring.core.formatsource.FormattedSourceEditProvider;
import org.rubypeople.rdt.refactoring.core.formatsource.Messages;
import org.rubypeople.rdt.refactoring.core.formatsource.PreviewGeneratorImpl;
import org.rubypeople.rdt.refactoring.ui.pages.FormatSourcePage;
import org.rubypeople.rdt.refactoring.util.FileHelper;

public class FormatSourceRefactoring
extends RubyRefactoring {
    public static final String NAME = Messages.FormatSourceRefactoring_Name;
    private static final String source = "class Sample\ndef testMethod arg1, arg2\nputs \"Hello world!\"\nhash = {:key => 'value'}\nend\ndef anotherTestMethod arg1, arg2\n[1, 2, 3, 4].each {|e| puts e}\nend\nend";
    private FormattedSourceEditProvider provider;

    public FormatSourceRefactoring() {
        super(NAME);
        FormatSourceConfig config = new FormatSourceConfig(this.getDocumentProvider());
        FormatSourceConditionChecker checker = new FormatSourceConditionChecker(config);
        this.setRefactoringConditionChecker(checker);
        if (checker.shouldPerform()) {
            this.provider = new FormattedSourceEditProvider(config);
            this.setEditProvider(this.provider);
            String lineDelmiter = FileHelper.getLineDelimiter(config.getDocumentProvider().getActiveFileContent());
            EditableFormatHelper formatHelper = new EditableFormatHelper(lineDelmiter);
            FormatSourcePage page = new FormatSourcePage(formatHelper, new PreviewGeneratorImpl(source));
            this.pages.add(page);
        }
    }
}

