/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.generateconstructor;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.generateconstructor.GeneratedConstructor;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditAndTreeContentProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.CheckableItem;
import org.rubypeople.rdt.refactoring.ui.IChildrenProvider;
import org.rubypeople.rdt.refactoring.ui.IParentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorsGenerator
extends EditAndTreeContentProvider {
    private Collection<TreeClass> classes = new ArrayList<TreeClass>();

    public ConstructorsGenerator(DocumentProvider docProvider) {
        ClassNodeProvider provider = docProvider.getClassNodeProvider();
        if (provider != null) {
            for (ClassNodeWrapper node : provider.getAllClassNodes()) {
                this.classes.add(new TreeClass(node));
            }
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.classes.toArray();
    }

    @Override
    public Collection<EditProvider> getEditProviders() {
        ArrayList<EditProvider> constructors = new ArrayList<EditProvider>();
        for (TreeClass treeClass : this.classes) {
            if (!treeClass.isChecked()) continue;
            constructors.add(treeClass.getGeneratedConstructor());
        }
        return constructors;
    }

    public static class TreeClass
    extends CheckableItem
    implements IChildrenProvider {
        private ClassNodeWrapper classNode;
        private Collection<TreeAttribute> attrs;
        private Collection<Node> attrNodes;

        public TreeClass(ClassNodeWrapper classNode) {
            super(false, false, true);
            this.classNode = classNode;
            this.attrNodes = classNode.getAttrNodes();
            this.attrs = new ArrayList<TreeAttribute>();
            for (Node node : this.attrNodes) {
                this.attrs.add(new TreeAttribute((INameNode)node));
            }
        }

        public String toString() {
            return this.classNode.getName();
        }

        public Object[] getChildren() {
            return this.attrs.toArray();
        }

        public boolean hasChildren() {
            return !this.attrs.isEmpty();
        }

        public GeneratedConstructor getGeneratedConstructor() {
            ArrayList<String> checkedAttrNodes = new ArrayList<String>();
            for (TreeAttribute treeAttr : this.attrs) {
                if (!treeAttr.isChecked()) continue;
                checkedAttrNodes.add(treeAttr.getAttrNode().getName().substring(1));
            }
            return new GeneratedConstructor(this.classNode, checkedAttrNodes);
        }

        public class TreeAttribute
        extends CheckableItem
        implements IParentProvider {
            private INameNode node;
            private String name;

            public TreeAttribute(INameNode node) {
                super(false, true, false);
                this.name = node.getName();
                if (this.name.indexOf(64) == 0) {
                    this.name = this.name.substring(1);
                }
                this.node = node;
            }

            public String toString() {
                return this.name;
            }

            public INameNode getAttrNode() {
                return this.node;
            }

            public Object getParent() {
                return TreeClass.this;
            }
        }
    }
}

