/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.generateconstructor;

import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.core.generateconstructor.ConstructorsGenerator;
import org.rubypeople.rdt.refactoring.core.generateconstructor.Messages;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.pages.ConstructorSelectionPage;

public class GenerateConstructorRefactoring
extends RubyRefactoring {
    public static final String NAME = Messages.GenerateConstructorRefactoring_Name;

    public GenerateConstructorRefactoring() {
        super(NAME);
        ConstructorsGenerator constructorsGenerator = new ConstructorsGenerator(this.getDocumentProvider());
        this.setEditProvider(constructorsGenerator);
        ConstructorSelectionPage page = new ConstructorSelectionPage(constructorsGenerator);
        this.pages.add(page);
        this.setInfoMessage(page);
    }

    private void setInfoMessage(ConstructorSelectionPage page) {
        if (this.getDocumentProvider().getClassNodeProvider() == null) {
            return;
        }
        StringBuilder classNames = new StringBuilder();
        for (ClassNodeWrapper classNode : this.getDocumentProvider().getClassNodeProvider().getAllClassNodes()) {
            if (!classNode.hasConstructor()) continue;
            classNames.append(String.valueOf(classNode.getName()) + ", ");
        }
        if (classNames.length() != 0) {
            page.setMessage(String.valueOf(Messages.GenerateConstructorRefactoring_TheClass) + (classNames.length() != 1 ? Messages.GenerateConstructorRefactoring_ClassesPluralForm : "") + ' ' + classNames.substring(0, classNames.length() - 2) + Messages.GenerateConstructorRefactoring_AlreadyContainsConstructors + "\n", 2);
        }
    }
}

