/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.generateconstructor;

import java.util.Collection;
import java.util.Iterator;
import org.jruby.ast.BlockNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.ConstructorOffsetProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedConstructor
extends InsertEditProvider {
    private Collection<String> arguments;
    private ClassNodeWrapper classNode;

    public GeneratedConstructor(ClassNodeWrapper classNode, Collection<String> arguments) {
        super(true);
        this.classNode = classNode;
        this.arguments = arguments;
    }

    protected BlockNode getInsertNode(int offset, String document) {
        return NodeFactory.createBlockNode(!this.isNextLineEmpty(offset, document), new Node[]{NodeFactory.createNewLineNode((Node)this.getConstructorNode())});
    }

    private DefnNode getConstructorNode() {
        return NodeFactory.createMethodNode("initialize", this.arguments.toArray(new String[this.arguments.size()]), this.arguments.size() > 0 ? this.getBody(this.arguments) : null);
    }

    private Node getBody(Collection<String> args) {
        Iterator<String> argsIter = args.iterator();
        BlockNode blockNode = new BlockNode((ISourcePosition)new IDESourcePosition());
        int i = 0;
        while (i < args.size()) {
            String name = argsIter.next();
            InstAsgnNode assignment = NodeFactory.createInstAsgnNode(String.valueOf('@') + name, NodeFactory.createLocalVarNode(name));
            if (i > 0) {
                blockNode.add((Node)NodeFactory.createNewLineNode((Node)assignment));
            } else {
                blockNode.add((Node)assignment);
            }
            ++i;
        }
        return blockNode;
    }

    @Override
    protected int getOffset(String document) {
        return new ConstructorOffsetProvider(this.classNode, document).getOffset();
    }
}

