/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinelocal;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.ClassNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.inlinelocal.InlineLocalConfig;
import org.rubypeople.rdt.refactoring.core.inlinelocal.Messages;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;
import org.rubypeople.rdt.refactoring.util.JRubyRefactoringUtils;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class InlineLocalConditionChecker
extends RefactoringConditionChecker {
    private InlineLocalConfig config;
    private RootNode rootNode;

    public InlineLocalConditionChecker(InlineLocalConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (InlineLocalConfig)configObj;
        this.rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        int caretPosition = this.config.getCaretPosition();
        this.config.setEnclosingMethod((MethodDefNode)SelectionNodeProvider.getSelectedNodeOfType((Node)this.rootNode, caretPosition, MethodDefNode.class));
        this.config.setEnclosingScopeNode(SelectionNodeProvider.getEnclosingScope((Node)this.rootNode, caretPosition));
        Node locVarNode = SelectionNodeProvider.getSelectedNodeOfType((Node)this.rootNode, caretPosition, LocalNodeWrapper.LOCAL_NODES_CLASSES);
        if (locVarNode == null) {
            return;
        }
        this.config.setSelectedItem(new LocalNodeWrapper(locVarNode));
        this.config.setSelectedItemName(LocalNodeWrapper.getLocalNodeName(this.config.getSelectedItem()));
        this.initDefinitionNode();
        this.initLocalOccurrences();
    }

    private void initDefinitionNode() {
        Collection<LocalNodeWrapper> asgnNodes = LocalNodeWrapper.gatherLocalAsgnNodes(this.config.getEnclosingScopeNode());
        for (LocalNodeWrapper currentAsgnNode : asgnNodes) {
            if (!currentAsgnNode.getName().equals(this.config.getSelectedItemName())) continue;
            this.config.setDefinitionNode(currentAsgnNode);
        }
    }

    private void initLocalOccurrences() {
        ArrayList<LocalNodeWrapper> localOccurrences = new ArrayList<LocalNodeWrapper>();
        Collection<LocalNodeWrapper> nodesInMethod = LocalNodeWrapper.gatherLocalVarNodes(this.config.getEnclosingScopeNode());
        for (LocalNodeWrapper currentLocalNode : nodesInMethod) {
            String currentNodeName = LocalNodeWrapper.getLocalNodeName(currentLocalNode);
            if (!currentNodeName.equals(this.config.getSelectedItemName())) continue;
            localOccurrences.add(currentLocalNode);
        }
        this.config.setLocalOccurences(localOccurrences);
    }

    protected void checkFinalConditions() {
        if (!this.isNewMethodNameUnique()) {
            this.addError(Messages.InlineLocalConditionChecker_NameNotUnique);
        }
    }

    protected void checkInitialConditions() {
        if (this.config.getSelectedItem() == null) {
            this.addError(Messages.InlineLocalConditionChecker_NoLocalVariable);
        } else if (this.isTempParameter()) {
            this.addError(Messages.InlineLocalConditionChecker_CannotMethodParameters);
        } else if (this.isBlockArgument()) {
            this.addError(Messages.InlineLocalConditionChecker_CannotBlockArgument);
        } else if (this.isTempMultiassigned()) {
            this.addError(Messages.InlineLocalConditionChecker_CannotMultiAssigned);
        } else if (this.defintiontionContainsItself()) {
            this.addError(Messages.InlineLocalConditionChecker_CannotSelfReferencing);
        } else if (this.isMultipleAsgnNode()) {
            this.addError(Messages.InlineLocalConditionChecker_CannotMultipleAssignments);
        } else if (!this.hasTarget()) {
            this.addError(Messages.InlineLocalConditionChecker_NoTarget);
        }
    }

    private boolean hasTarget() {
        return !this.config.getLocalOccurrences().isEmpty();
    }

    private boolean isBlockArgument() {
        IterNode enclosingIterNode = (IterNode)SelectionNodeProvider.getSelectedNodeOfType((Node)this.rootNode, this.config.getCaretPosition(), IterNode.class);
        if (enclosingIterNode == null) {
            return false;
        }
        Node varNode = enclosingIterNode.getVarNode();
        return this.config.getSelectedItem().getWrappedNode().equals(varNode);
    }

    private boolean isMultipleAsgnNode() {
        Node enclosingMultipleAssignmentNode = SelectionNodeProvider.getSelectedNodeOfType(this.config.getEnclosingScopeNode(), this.config.getCaretPosition(), MultipleAsgnNode.class);
        return enclosingMultipleAssignmentNode != null;
    }

    private boolean isTempParameter() {
        if (this.config.getEnclosingMethod() == null || !this.config.getSelectedItem().hasValidId()) {
            return false;
        }
        return JRubyRefactoringUtils.isParameter(this.config.getSelectedItem(), this.config.getEnclosingMethod());
    }

    private boolean isNewMethodNameUnique() {
        Node environment = SelectionNodeProvider.getSelectedNodeOfType((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getCaretPosition(), ClassNode.class, RootNode.class);
        Collection<MethodDefNode> methodNodes = NodeProvider.gatherMethodDefinitionNodes(NodeUtil.getBody(environment));
        for (MethodDefNode currentDefnNode : methodNodes) {
            if (!currentDefnNode.getName().equals(this.config.getNewMethodName())) continue;
            return false;
        }
        return true;
    }

    private boolean isTempMultiassigned() {
        Collection<LocalNodeWrapper> nodesInMethod = LocalNodeWrapper.gatherLocalAsgnNodes(this.config.getEnclosingScopeNode());
        int countOccurrence = 0;
        for (LocalNodeWrapper currentLocalNode : nodesInMethod) {
            String currentNodeName = LocalNodeWrapper.getLocalNodeName(currentLocalNode);
            if (!currentNodeName.equals(this.config.getSelectedItemName())) continue;
            ++countOccurrence;
        }
        return countOccurrence > 1;
    }

    private boolean defintiontionContainsItself() {
        if (this.config.getDefinitionNode() == null) {
            return false;
        }
        ISourcePosition defPosition = this.config.getDefinitionNode().getWrappedNode().getPosition();
        for (LocalNodeWrapper currentOccurrence : this.config.getLocalOccurrences()) {
            ISourcePosition occurrencePosition = currentOccurrence.getWrappedNode().getPosition();
            if (defPosition.getStartOffset() > occurrencePosition.getStartOffset() || defPosition.getEndOffset() < occurrencePosition.getEndOffset()) continue;
            return true;
        }
        return false;
    }
}

