/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinemethod;

import java.util.ArrayList;
import java.util.HashSet;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.parser.StaticScope;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.inlinemethod.ITargetClassFinder;
import org.rubypeople.rdt.refactoring.core.inlinemethod.InlineMethodConfig;
import org.rubypeople.rdt.refactoring.core.inlinemethod.Messages;
import org.rubypeople.rdt.refactoring.core.inlinemethod.MethodBodyStatementReplacer;
import org.rubypeople.rdt.refactoring.core.inlinemethod.MethodFinder;
import org.rubypeople.rdt.refactoring.core.inlinemethod.ParameterReplacer;
import org.rubypeople.rdt.refactoring.core.inlinemethod.RenameDuplicatedVariables;
import org.rubypeople.rdt.refactoring.core.inlinemethod.ReturnStatementReplacer;
import org.rubypeople.rdt.refactoring.core.inlinemethod.SelectedCallFinder;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class InlineMethodConditionChecker
extends RefactoringConditionChecker {
    private InlineMethodConfig config;

    public InlineMethodConditionChecker(InlineMethodConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (InlineMethodConfig)configObj;
        if (!(this.findSelectedCall(this.config.getPos()) && this.findTargetClass(this.config.getTargetClassFinder()) && this.findMethodDefinition())) {
            return;
        }
        this.config.setCallParent(NodeProvider.findParentNode((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getSelectedCall().getWrappedNode()));
        this.replaceParameters();
        if (this.resultIsAssigned()) {
            this.replaceReturnStatements();
        }
        this.createInlinedMethodBody(this.config.getDocumentProvider());
        this.renameDuplicates(this.config.getDocumentProvider());
    }

    private void renameDuplicates(IDocumentProvider doc) {
        StaticScope parent = NodeUtil.getScope(SelectionNodeProvider.getEnclosingScope((Node)doc.getActiveFileRootNode(), this.config.getSelectedCall().getWrappedNode()));
        ArrayList<String> localNames = new ArrayList<String>();
        if (parent.getVariables() != null) {
            String[] stringArray = parent.getVariables();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                localNames.add(name);
                ++n2;
            }
        }
        if (this.resultIsAssigned()) {
            AssignableNode callParent = (AssignableNode)this.config.getCallParent();
            if (callParent instanceof INameNode) {
                String name = ((INameNode)callParent).getName();
                localNames.remove(name);
            } else {
                ListNode head = ((MultipleAsgnNode)callParent).getHeadNode();
                localNames.removeAll(head.childNodes());
            }
        }
        this.config.setMethodDefDoc(new RenameDuplicatedVariables().rename(new StringDocumentProvider(this.config.getMethodDefDoc()), localNames.toArray(new String[localNames.size()])));
    }

    private boolean findSelectedCall(int pos) {
        this.config.setSelectedCall(new SelectedCallFinder().findSelectedCall(pos, this.config.getDocumentProvider()));
        return this.config.getSelectedCall() != null;
    }

    private boolean findTargetClass(ITargetClassFinder targetClassFinder) {
        this.config.setClassName(targetClassFinder.findTargetClass(this.config.getSelectedCall(), this.config.getDocumentProvider()));
        return this.config.getClassName() != null && !"".equals(this.config.getClassName());
    }

    private boolean findMethodDefinition() {
        this.config.setMethodDefinitionNode(new MethodFinder().find(this.config.getClassName(), this.config.getSelectedCall().getName(), this.config.getDocumentProvider()));
        return this.config.getMethodDefinitionNode() != null;
    }

    private void replaceParameters() {
        this.config.setMethodDefDoc(new ParameterReplacer().replace(this.config.getDocumentProvider(), this.config.getSelectedCall(), this.config.getMethodDefinitionNode()));
    }

    private void createInlinedMethodBody(IDocumentProvider doc) {
        MethodBodyStatementReplacer bodyReplacer = new MethodBodyStatementReplacer();
        if (this.config.getSelectedCall().getReceiverNode() != null) {
            String name = ((INameNode)this.config.getSelectedCall().getReceiverNode()).getName();
            this.config.setMethodDefDoc(bodyReplacer.replaceSelfWithObject(this.config.getMethodDefDoc(), name));
            this.config.setMethodDefDoc(bodyReplacer.prefixCallsWithObject(this.config.getMethodDefDoc(), new IncludedClassesProvider(doc), this.config.getClassName(), name));
            HashSet<String> usedMembers = new HashSet<String>();
            this.config.setMethodDefDoc(bodyReplacer.replaceVarsWithAccessor(this.config.getMethodDefDoc(), name, usedMembers));
            this.config.setUsedMembers(usedMembers);
        }
        this.config.setMethodDefDoc(bodyReplacer.removeReturnStatements(this.config.getMethodDefDoc()));
    }

    private void replaceReturnStatements() {
        ReturnStatementReplacer returnReplacer = new ReturnStatementReplacer();
        this.config.setSingleReturnStatement(returnReplacer.singleReturnOnLastLine(this.config.getMethodDefDoc()));
        if (returnReplacer.singleReturnOnLastLine(this.config.getMethodDefDoc())) {
            this.config.setMethodDefDoc(returnReplacer.replaceReturn(this.config.getMethodDefDoc(), (AssignableNode)this.config.getCallParent()));
        }
    }

    private boolean resultIsAssigned() {
        return this.config.getCallParent() instanceof AssignableNode;
    }

    protected void checkInitialConditions() {
        if (this.config.getSelectedCall() == null) {
            this.addError(Messages.InlineMethodConditionChecker_NoMethodCall);
        } else if (this.config.getClassName() == null || "".equals(this.config.getClassName())) {
            this.addError(Messages.InlineMethodConditionChecker_CannotGuessType);
        } else if (this.config.getMethodDefinitionNode() == null) {
            this.addError(Messages.InlineMethodConditionChecker_CannotFindDefinition);
        } else if (this.config.isSingleReturnStatement() != null && !this.config.isSingleReturnStatement().booleanValue()) {
            this.addError(Messages.InlineMethodConditionChecker_ToManyReturns);
        }
    }

    protected void checkFinalConditions() {
    }
}

