/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinemethod;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.FCallNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.inlinemethod.IMethodBodyStatementReplacer;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBodyStatementReplacer
implements IMethodBodyStatementReplacer {
    @Override
    public DocumentProvider replaceSelfWithObject(DocumentProvider doc, String object) {
        Collection<Node> selfNodes = null;
        StringDocumentProvider result = new StringDocumentProvider(doc);
        do {
            if ((selfNodes = NodeProvider.gatherNodesOfTypeInAktScopeNode(result.getActiveFileRootNode().getBodyNode(), SelfNode.class)).isEmpty()) continue;
            SelfNode node = (SelfNode)selfNodes.iterator().next();
            StringBuilder tempResult = new StringBuilder();
            tempResult.append(result.getActiveFileContent().substring(0, node.getPosition().getStartOffset()));
            tempResult.append(object);
            tempResult.append(result.getActiveFileContent().substring(node.getPosition().getEndOffset()));
            result = new StringDocumentProvider("part_of_" + doc.getActiveFileName(), tempResult.toString());
        } while (!selfNodes.isEmpty());
        return result;
    }

    public DocumentProvider replaceVarsWithAccessor(DocumentProvider doc, String object, Collection<String> usedMembers) {
        StringDocumentProvider result = new StringDocumentProvider(doc);
        Collection<Node> varNodes = null;
        do {
            varNodes = NodeProvider.gatherNodesOfTypeInAktScopeNode(result.getActiveFileRootNode().getBodyNode(), InstVarNode.class, InstAsgnNode.class);
            for (Node actVarNode : new ArrayList<Node>(varNodes)) {
                if (!((INameNode)actVarNode).getName().equals(object)) continue;
                varNodes.remove(actVarNode);
            }
            if (varNodes.isEmpty()) continue;
            Node varNode = varNodes.iterator().next();
            String name = ((INameNode)varNode).getName();
            usedMembers.add(name);
            StringBuilder src = new StringBuilder(result.getActiveFileContent());
            src.replace(varNode.getPosition().getStartOffset(), varNode.getPosition().getStartOffset() + name.length(), String.valueOf(object) + '.' + name.substring(1));
            result = new StringDocumentProvider("part_of_" + doc.getActiveFileName(), src.toString());
        } while (!varNodes.isEmpty());
        return result;
    }

    @Override
    public DocumentProvider prefixCallsWithObject(DocumentProvider doc, IncludedClassesProvider provider, String className, String object) {
        StringDocumentProvider result = new StringDocumentProvider(doc);
        MethodCallNodeWrapper call = null;
        while ((call = this.findCallToMethodInClass(result, provider, className)) != null) {
            StringBuilder src = new StringBuilder(result.getActiveFileContent());
            src.insert(call.getWrappedNode().getPosition().getStartOffset(), String.valueOf(object) + '.');
            result = new StringDocumentProvider("part_of_" + doc.getActiveFileName(), src.toString());
        }
        return result;
    }

    private MethodCallNodeWrapper findCallToMethodInClass(DocumentProvider doc, IncludedClassesProvider provider, String className) {
        Collection<MethodNodeWrapper> definedMethods = provider.getAllMethodsFor(className);
        for (MethodCallNodeWrapper node : this.findFAndVCalls(doc)) {
            for (MethodNodeWrapper methods : definedMethods) {
                if (!methods.getName().equals(node.getName())) continue;
                return node;
            }
        }
        return null;
    }

    private Collection<MethodCallNodeWrapper> findFAndVCalls(DocumentProvider doc) {
        ArrayList<MethodCallNodeWrapper> methodCalls = new ArrayList<MethodCallNodeWrapper>();
        for (Node node : NodeProvider.gatherNodesOfTypeInAktScopeNode(doc.getActiveFileRootNode().getBodyNode(), VCallNode.class, FCallNode.class)) {
            methodCalls.add(new MethodCallNodeWrapper(node));
        }
        return methodCalls;
    }

    @Override
    public DocumentProvider removeReturnStatements(DocumentProvider doc) {
        Collection<Node> nodes = null;
        StringDocumentProvider result = new StringDocumentProvider(doc);
        while (!(nodes = NodeProvider.getSubNodes((Node)result.getActiveFileRootNode(), ReturnNode.class)).isEmpty()) {
            StringBuilder newBody = new StringBuilder(result.getActiveFileContent());
            int startOffset = nodes.iterator().next().getPosition().getStartOffset();
            newBody.replace(startOffset, startOffset + "return ".length(), "");
            result = new StringDocumentProvider("part_of_" + doc.getActiveFileName(), newBody.toString());
            if (!nodes.isEmpty()) continue;
        }
        return result;
    }
}

