/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinemethod;

import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.inlinemethod.IReturnStatementReplacer;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.util.FileHelper;

public class ReturnStatementReplacer
implements IReturnStatementReplacer {
    public boolean singleReturnOnLastLine(DocumentProvider doc) {
        if (this.countReturnNodes(doc) > 1) {
            return false;
        }
        if (this.countReturnNodes(doc) == 1) {
            return this.returnIsOnLastLine(this.getReturnNode(doc), doc);
        }
        return true;
    }

    private boolean returnIsOnLastLine(ReturnNode node, DocumentProvider doc) {
        return node.getPosition().getStartLine() == doc.getActiveFileContent().split("(\\r)?\\n").length - 1;
    }

    private int countReturnNodes(DocumentProvider doc) {
        int returnNodes = 0;
        for (Node node : NodeProvider.getAllNodes((Node)doc.getActiveFileRootNode())) {
            if (!(node instanceof ReturnNode)) continue;
            ++returnNodes;
        }
        return returnNodes;
    }

    private ReturnNode getReturnNode(DocumentProvider doc) {
        for (Node node : NodeProvider.getAllNodes((Node)doc.getActiveFileRootNode())) {
            if (!(node instanceof ReturnNode)) continue;
            return (ReturnNode)node;
        }
        return null;
    }

    public DocumentProvider replaceReturn(DocumentProvider doc, AssignableNode target) {
        if (!this.singleReturnOnLastLine(doc) || target == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        ReturnNode returnNode = this.getReturnNode(doc);
        if (returnNode == null) {
            this.insertLastLineToAssignment(doc, target, result);
        } else {
            this.replaceReturnStatementWithAssignment(doc, target, result, returnNode);
        }
        return new StringDocumentProvider("part_of_" + doc.getActiveFileName(), result.append(ReWriteVisitor.createCodeFromNode((Node)target, (String)doc.getActiveFileContent())).toString());
    }

    private void insertLastLineToAssignment(DocumentProvider doc, AssignableNode target, StringBuilder result) {
        String[] lines = doc.getActiveFileContent().split("(\\r)?\\n");
        target.setValueNode(NodeProvider.getRootNode("last_line_of_" + doc.getActiveFileName() + "_for_ReturnStatementReplacer", lines[lines.length - 1]).getBodyNode());
        String lineDelimiter = FileHelper.getLineDelimiter(doc.getActiveFileContent());
        int i = 0;
        while (i < lines.length - 1) {
            result.append(lines[i]);
            result.append(lineDelimiter);
            ++i;
        }
    }

    private void replaceReturnStatementWithAssignment(DocumentProvider doc, AssignableNode target, StringBuilder result, ReturnNode returnNode) {
        target.setValueNode(returnNode.getValueNode());
        result.append(doc.getActiveFileContent().substring(0, returnNode.getPosition().getStartOffset()));
    }
}

