/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movefield;

import java.util.Collection;
import org.rubypeople.rdt.refactoring.core.movefield.GenerateAccessorAtSource;
import org.rubypeople.rdt.refactoring.core.movefield.GenerateAccessorsAtTarget;
import org.rubypeople.rdt.refactoring.core.movefield.MoveFieldConfig;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldRenamer;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConfig;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentWithIncluding;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiFileEditProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveFieldEditProvider
implements IMultiFileEditProvider {
    private final MoveFieldConfig config;

    public MoveFieldEditProvider(MoveFieldConfig config) {
        this.config = config;
    }

    @Override
    public Collection<FileMultiEditProvider> getFileEditProviders() {
        MultiFileEditProvider providers = new MultiFileEditProvider();
        this.addTargetAccessorGenerator(providers);
        this.addSourceAccessorGenerator(providers);
        this.addFieldRenamers(providers);
        return providers.getFileEditProviders();
    }

    private void addFieldRenamers(MultiFileEditProvider providers) {
        RenameFieldConfig renameFieldConfig = new RenameFieldConfig(new DocumentWithIncluding(this.config.getDocumentProvider()), this.config.getPos());
        new RenameFieldConditionChecker(renameFieldConfig);
        renameFieldConfig.setDoRenameAccessorMethods(false);
        renameFieldConfig.setDoRenameAccessors(false);
        renameFieldConfig.setNewName(String.valueOf(this.config.getTargetReference()) + '.' + this.config.getSelectedFieldName());
        FieldRenamer renamer = new FieldRenamer(renameFieldConfig);
        for (FileMultiEditProvider fileMultiEditProvider : renamer.getFileEditProviders()) {
            for (EditProvider editProvider : fileMultiEditProvider.getEditProviders()) {
                providers.addEditProvider(new FileEditProvider(fileMultiEditProvider.getFileName(), editProvider));
            }
        }
    }

    private void addTargetAccessorGenerator(MultiFileEditProvider providers) {
        GenerateAccessorsAtTarget generateAccessors = new GenerateAccessorsAtTarget(this.config.getDocumentProvider(), this.config.getTargetClass(), this.config.getSelectedFieldName());
        providers.addEditProvider(new FileEditProvider(generateAccessors.getFileName(), generateAccessors.getEditProvider()));
    }

    private void addSourceAccessorGenerator(MultiFileEditProvider providers) {
        GenerateAccessorAtSource accessorAtSource = new GenerateAccessorAtSource(this.config);
        for (EditProvider edit : accessorAtSource.getEditProviders()) {
            providers.addEditProvider(new FileEditProvider(this.config.getDocumentProvider().getActiveFileName(), edit));
        }
    }
}

