/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movemethod;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovePartOfVisibilityNodeProvider
extends ReplaceEditProvider {
    private VisibilityNodeWrapper visibilityNode;
    private Collection<String> methodNamesToDelete;
    private Collection<String> remainingMethodNames;

    public RemovePartOfVisibilityNodeProvider(VisibilityNodeWrapper visibilityNode, Collection<String> methodNamesToDelete) {
        this.visibilityNode = visibilityNode;
        this.methodNamesToDelete = methodNamesToDelete;
        this.initRemainingNames();
    }

    private void initRemainingNames() {
        this.remainingMethodNames = new ArrayList<String>(this.visibilityNode.getMethodNames());
        for (String aktName : this.methodNamesToDelete) {
            if (!this.remainingMethodNames.contains(aktName)) continue;
            this.remainingMethodNames.remove(aktName);
        }
    }

    @Override
    protected int getOffsetLength() {
        return this.visibilityNode.getPosition().getEndOffset() - this.visibilityNode.getPosition().getStartOffset();
    }

    @Override
    protected Node getEditNode(int offset, String document) {
        VisibilityNodeWrapper.METHOD_VISIBILITY visibility = this.visibilityNode.getVisibility();
        return NodeFactory.createVisibilityNode(visibility, this.remainingMethodNames.toArray(new String[this.remainingMethodNames.size()]));
    }

    @Override
    protected int getOffset(String document) {
        return this.visibilityNode.getPosition().getStartOffset();
    }

    public boolean shouldRemoveAll() {
        return this.remainingMethodNames.isEmpty();
    }

    public boolean hasChange() {
        return this.remainingMethodNames.size() < this.visibilityNode.getMethodNames().size();
    }
}

