/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movemethod;

import org.jruby.ast.Node;
import org.jruby.ast.SelfNode;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.movemethod.MoveMethodConfig;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.CallArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;

public class ReplaceMethodCallEditProvider
extends ReplaceEditProvider {
    private MethodCallNodeWrapper methodCallNode;
    private MoveMethodConfig config;

    public ReplaceMethodCallEditProvider(MethodCallNodeWrapper methodCallNode, MoveMethodConfig config) {
        super(false);
        this.config = config;
        this.methodCallNode = methodCallNode;
    }

    protected int getOffsetLength() {
        return this.methodCallNode.getPosition().getEndOffset() - this.methodCallNode.getPosition().getStartOffset();
    }

    protected Node getEditNode(int offset, String document) {
        Object receiverNode = !this.methodCallNode.isCallToClassMethod() ? NodeFactory.createInstVarNode(this.config.getFieldInSourceClassOfTypeDestinationClass()) : NodeFactory.createConstNode(this.config.getDestinationClassNode().getName());
        CallArgsNodeWrapper argsNode = new CallArgsNodeWrapper(this.methodCallNode.getArgsNode());
        if (this.config.doesNewMethodNeedsReferenceToSourceClass()) {
            SelfNode selfNode = NodeFactory.createSelfNode();
            return NodeFactory.createCallNode((Node)receiverNode, this.config.getMovedMethodName(), argsNode.cloneWithAddedArg((Node)selfNode));
        }
        return NodeFactory.createCallNode((Node)receiverNode, this.config.getMovedMethodName(), argsNode.getWrappedNode());
    }

    protected int getOffset(String document) {
        return this.methodCallNode.getPosition().getStartOffset();
    }
}

