/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.pullup;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.BlockNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.ConstructorOffsetProvider;
import org.rubypeople.rdt.refactoring.offsetprovider.MethodOffsetProvider;
import org.rubypeople.rdt.refactoring.offsetprovider.OffsetProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpPulledMethods
extends InsertEditProvider {
    private Collection<MethodNodeWrapper> methodNodes;
    private boolean constructors;
    private ClassNodeWrapper classNode;

    public UpPulledMethods(Collection<MethodNodeWrapper> methodNodes, ClassNodeWrapper classNode, boolean constructors) {
        super(true);
        this.methodNodes = methodNodes;
        this.constructors = constructors;
        this.classNode = classNode;
    }

    protected BlockNode getInsertNode(int offset, String document) {
        boolean needsNewLineAtEndOfBlock = this.lastEditInGroup && !this.isNextLineEmpty(offset, document);
        return NodeFactory.createBlockNode(needsNewLineAtEndOfBlock, this.getMethodNodes(this.methodNodes));
    }

    private Node[] getMethodNodes(Collection<MethodNodeWrapper> nodeCollection) {
        ArrayList<NewlineNode> nodes = new ArrayList<NewlineNode>();
        boolean first = true;
        for (MethodNodeWrapper methodNode : nodeCollection) {
            if (first) {
                first = false;
            } else {
                nodes.add(NodeFactory.createNewLineNode(null));
            }
            nodes.add(NodeFactory.createNewLineNode((Node)methodNode.getWrappedNode()));
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    protected int getOffset(String document) {
        OffsetProvider offsetProvider = this.constructors ? new ConstructorOffsetProvider(this.classNode, document) : new MethodOffsetProvider(this.classNode, document);
        return offsetProvider.getOffset();
    }
}

