/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.pushdown;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.BlockNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.pushdown.NewClassOffsetProvier;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownPushedMethodsClass
extends InsertEditProvider {
    private Collection<MethodNodeWrapper> methodNodes;
    private Collection<MethodNodeWrapper> constructorNodes;
    private String className;

    public DownPushedMethodsClass(String className, Collection<MethodNodeWrapper> allMethodNodes) {
        super(true);
        this.className = className;
        this.initConstrucorAndMethodNodes(allMethodNodes);
    }

    private void initConstrucorAndMethodNodes(Collection<MethodNodeWrapper> allMethodNodes) {
        this.methodNodes = new ArrayList<MethodNodeWrapper>();
        this.constructorNodes = new ArrayList<MethodNodeWrapper>();
        for (MethodNodeWrapper node : allMethodNodes) {
            if (node.getSignature().isConstructor()) {
                this.constructorNodes.add(node);
                continue;
            }
            this.methodNodes.add(node);
        }
    }

    protected BlockNode getInsertNode(int offset, String document) {
        if (this.firstEditInGroup) {
            this.setInsertType(1);
        }
        boolean needsNewLineAtEndOfBlock = this.lastEditInGroup && !this.isNextLineEmpty(offset, document);
        Node classNode = this.getClassNode();
        BlockNode blockNode = NodeFactory.createBlockNode();
        blockNode.add(classNode);
        if (!this.firstEditInGroup) {
            blockNode.add((Node)NodeFactory.createNewLineNode(null));
        }
        if (needsNewLineAtEndOfBlock) {
            blockNode.add((Node)NodeFactory.createNewLineNode(null));
        }
        return blockNode;
    }

    private Node getClassNode() {
        return NodeFactory.createNewLineNode((Node)NodeFactory.createClassNode(this.className, this.getBody()));
    }

    private Node getBody() {
        BlockNode body = new BlockNode((ISourcePosition)new IDESourcePosition());
        body.add((Node)NodeFactory.createNewLineNode(null));
        for (MethodNodeWrapper constructor : this.constructorNodes) {
            body.add((Node)NodeFactory.createNewLineNode((Node)constructor.getWrappedNode()));
        }
        for (MethodNodeWrapper method : this.methodNodes) {
            body.add((Node)NodeFactory.createNewLineNode((Node)method.getWrappedNode()));
        }
        body.add((Node)NodeFactory.createNewLineNode(null));
        return body;
    }

    @Override
    protected int getOffset(String document) {
        NewClassOffsetProvier offsetProvider = new NewClassOffsetProvier();
        return offsetProvider.getOffset();
    }
}

