/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.pushdown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.classnodeprovider.AllFilesClassNodeProvider;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.pushdown.DownPushedMethods;
import org.rubypeople.rdt.refactoring.core.pushdown.DownPushedMethodsClass;
import org.rubypeople.rdt.refactoring.core.pushdown.Messages;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentWithIncluding;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditAndTreeContentProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProviderGroups;
import org.rubypeople.rdt.refactoring.editprovider.ITreeClass;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.IChildrenProvider;
import org.rubypeople.rdt.refactoring.ui.IItemSelectionReceiver;
import org.rubypeople.rdt.refactoring.ui.IParentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDownPusher
extends EditAndTreeContentProvider
implements IItemSelectionReceiver {
    private Object[] selectedTreeItems;
    private ClassNodeProvider projectClassNodeProvider;
    private ClassNodeProvider classNodeProvider;

    public MethodDownPusher(DocumentProvider documentProvider) {
        this.projectClassNodeProvider = new AllFilesClassNodeProvider(new DocumentWithIncluding(documentProvider));
        this.classNodeProvider = documentProvider.getClassNodeProvider();
        this.initTreeClasses(this.classNodeProvider);
    }

    @Override
    protected ITreeClass createTreeClass(ClassNodeWrapper classNode) {
        return new TreeClass(classNode);
    }

    @Override
    public Collection<EditProvider> getEditProviders() {
        EditProviderGroups editProviderGroups = new EditProviderGroups();
        if (this.selectedTreeItems != null) {
            Object[] objectArray = this.selectedTreeItems;
            int n = this.selectedTreeItems.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof TreeClass) {
                    TreeClass treeClass = (TreeClass)o;
                    treeClass.addDownPushedMethods(editProviderGroups);
                }
                ++n2;
            }
        }
        return editProviderGroups.getAllEditProviders();
    }

    @Override
    public void setSelectedItems(Object[] checkedElements) {
        this.selectedTreeItems = (Object[])checkedElements.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeClass
    implements IChildrenProvider,
    ITreeClass {
        private ClassNodeWrapper classNode;
        private Collection<DownPushableMethod> downPushableMethods;
        private Collection<ClassNodeWrapper> childClassNodes;

        public TreeClass(ClassNodeWrapper classNode) {
            this.classNode = classNode;
            this.downPushableMethods = new ArrayList<DownPushableMethod>();
            this.childClassNodes = MethodDownPusher.this.projectClassNodeProvider.getSubClassesOf(classNode.getName());
            if (!this.childClassNodes.isEmpty()) {
                for (MethodNodeWrapper methodNode : classNode.getMethods()) {
                    this.downPushableMethods.add(new DownPushableMethod(methodNode));
                }
            }
        }

        public void addDownPushedMethods(EditProviderGroups editProviderGroups) {
            Collection<MethodNodeWrapper> checkedMethods = this.getCheckedMethods();
            for (ClassNodeWrapper childClassNode : this.childClassNodes) {
                String childClassName = childClassNode.getName();
                if (MethodDownPusher.this.classNodeProvider.hasClassNode(childClassName)) {
                    ClassNodeWrapper classNode = MethodDownPusher.this.classNodeProvider.getClassNode(childClassName);
                    this.addDownPushedMethods(classNode, checkedMethods, editProviderGroups);
                    continue;
                }
                this.addDownPushedMethodsClass(childClassName, checkedMethods, editProviderGroups);
            }
            this.addRemoveEdits(checkedMethods, editProviderGroups);
        }

        private void addRemoveEdits(Collection<MethodNodeWrapper> checkedMethods, EditProviderGroups editProviderGroups) {
            for (MethodNodeWrapper methodNode : checkedMethods) {
                editProviderGroups.add(Messages.MethodDownPusher_RemoveOldMethods, new DeleteEditProvider((Node)methodNode.getWrappedNode()));
            }
        }

        private void addDownPushedMethods(ClassNodeWrapper childClassNode, Collection<MethodNodeWrapper> checkedMethods, EditProviderGroups editProviderGroups) {
            ArrayList<MethodNodeWrapper> constructorNodes = new ArrayList<MethodNodeWrapper>();
            ArrayList<MethodNodeWrapper> methodNodes = new ArrayList<MethodNodeWrapper>();
            this.separateConstructors(checkedMethods, methodNodes, constructorNodes);
            if (!constructorNodes.isEmpty()) {
                DownPushedMethods constructors = new DownPushedMethods(constructorNodes, childClassNode, true);
                editProviderGroups.add(String.valueOf(Messages.MethodDownPusher_Constructors) + childClassNode.getName(), constructors);
            }
            if (!methodNodes.isEmpty()) {
                DownPushedMethods methods = new DownPushedMethods(methodNodes, childClassNode, false);
                editProviderGroups.add(String.valueOf(Messages.MethodDownPusher_Methods) + childClassNode.getName(), methods);
            }
        }

        private void separateConstructors(Collection<MethodNodeWrapper> nodes, Collection<MethodNodeWrapper> methodNodes, Collection<MethodNodeWrapper> constructorNodes) {
            for (MethodNodeWrapper method : nodes) {
                if (method.getSignature().isConstructor()) {
                    constructorNodes.add(method);
                    continue;
                }
                methodNodes.add(method);
            }
        }

        private Collection<MethodNodeWrapper> getCheckedMethods() {
            Collection allCheckedItems = Arrays.asList(MethodDownPusher.this.selectedTreeItems);
            ArrayList<MethodNodeWrapper> checkedMethods = new ArrayList<MethodNodeWrapper>();
            for (DownPushableMethod method : this.downPushableMethods) {
                if (!allCheckedItems.contains(method)) continue;
                checkedMethods.add(method.getMethodNode());
            }
            return checkedMethods;
        }

        private void addDownPushedMethodsClass(String className, Collection<MethodNodeWrapper> checkedMethods, EditProviderGroups editProviderGroups) {
            DownPushedMethodsClass methodsClass = new DownPushedMethodsClass(className, checkedMethods);
            editProviderGroups.add(Messages.MethodDownPusher_NewClasses, methodsClass);
        }

        public String toString() {
            return this.classNode.getName();
        }

        @Override
        public Object[] getChildren() {
            return this.downPushableMethods.toArray();
        }

        @Override
        public boolean hasChildren() {
            return !this.downPushableMethods.isEmpty();
        }

        public class DownPushableMethod
        implements IParentProvider {
            private MethodNodeWrapper methodNode;

            public DownPushableMethod(MethodNodeWrapper methodNode) {
                this.methodNode = methodNode;
            }

            public String toString() {
                return this.methodNode.getName();
            }

            public Object getParent() {
                return TreeClass.this;
            }

            public TreeClass getTreeClass() {
                return TreeClass.this;
            }

            public MethodNodeWrapper getMethodNode() {
                return this.methodNode;
            }
        }
    }
}

