/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renameclass;

import org.jruby.ast.CallNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.util.NameHelper;

public class ConstructorCall {
    private final CallNode node;

    public ConstructorCall(CallNode node) {
        assert (node.getName().equals("new"));
        assert (node.getReceiverNode() instanceof ConstNode || node.getReceiverNode() instanceof Colon2Node);
        this.node = node;
    }

    public String getClassName() {
        return NameHelper.getFullyQualifiedName(this.node.getReceiverNode());
    }

    public CallNode getNode() {
        return this.node;
    }

    public Node getArgs() {
        return this.node.getArgsNode();
    }

    public void setName(String newName) {
        if (this.node.getReceiverNode() instanceof ConstNode) {
            ((ConstNode)this.node.getReceiverNode()).setName(newName);
        } else {
            ((Colon2Node)this.node.getReceiverNode()).setName(newName);
        }
    }

    public int getReceiverOffset() {
        return this.node.getReceiverNode().getPosition().getStartOffset();
    }

    public int getReceiverLength() {
        return this.node.getReceiverNode().getPosition().getEndOffset() - this.getReceiverOffset();
    }
}

