/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renameclass;

import java.util.ArrayList;
import org.rubypeople.rdt.refactoring.core.ConstNameValidator;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.core.renameclass.Messages;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassConditionChecker;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassConfig;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassEditProvider;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassFileNameChangeProvider;
import org.rubypeople.rdt.refactoring.ui.NewNameListener;
import org.rubypeople.rdt.refactoring.ui.pages.RenamePage;

public class RenameClassRefactoring
extends RubyRefactoring {
    public static final String NAME = Messages.RenameClassRefactoring_Name;

    public RenameClassRefactoring(IRefactoringContext selectionProvider) {
        super(NAME, selectionProvider);
        RenameClassConfig renameClassConfig = new RenameClassConfig(this.getDocumentProvider(), selectionProvider.getCaretPosition());
        RenameClassConditionChecker conditionChecker = new RenameClassConditionChecker(renameClassConfig);
        this.setRefactoringConditionChecker(conditionChecker);
        if (conditionChecker.shouldPerform()) {
            RenameClassEditProvider editProvider = new RenameClassEditProvider(renameClassConfig);
            this.setEditProvider(editProvider);
            this.setFileNameChangeProvider(new RenameClassFileNameChangeProvider(renameClassConfig));
            this.pages.add(new RenamePage(NAME, renameClassConfig.getSelectedNode().getCPath().getName(), new NewNameListener(renameClassConfig, new ConstNameValidator(), new ArrayList<String>())));
        }
    }
}

