/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamefield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.SymbolNode;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.Messages;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.AttrFieldItem;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.ClassVarAsgnFieldItem;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.ClassVarFieldItem;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.FieldItem;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.InstAsgnFieldItem;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.InstVarFieldItem;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldProvider {
    private ClassNodeWrapper classNode;
    private Collection<ClassNodeWrapper> relatedClasses;
    private LinkedHashMap<String, ArrayList<FieldItem>> fields;
    private IDocumentProvider docProvider;

    public FieldProvider(ClassNodeWrapper classNode, IDocumentProvider docProvider) {
        this.classNode = classNode;
        this.fields = new LinkedHashMap();
        this.docProvider = docProvider;
        this.initRelatedClasses();
        for (ClassNodeWrapper currentClass : this.relatedClasses) {
            this.initAttrs(currentClass);
            this.initAccessors(currentClass);
            this.initClassFields(currentClass);
        }
    }

    private void initRelatedClasses() {
        this.relatedClasses = new ArrayList<ClassNodeWrapper>();
        Collection<ClassNodeWrapper> itselfAndSuperclasses = this.docProvider.getProjectClassNodeProvider().getClassAndAllSuperClasses(this.classNode);
        this.relatedClasses.addAll(itselfAndSuperclasses);
        Collection<ClassNodeWrapper> subclasses = this.docProvider.getProjectClassNodeProvider().getSubClassesOf(this.classNode.getName());
        this.relatedClasses.addAll(subclasses);
    }

    private void initClassFields(ClassNodeWrapper classWrapper) {
        Collection<Node> allOccurences = classWrapper.getClassFieldOccurences();
        for (Node currentAttr : allOccurences) {
            if (currentAttr instanceof ClassVarNode) {
                ClassVarNode classVar = (ClassVarNode)currentAttr;
                if (this.isVarSubNodeOfAsgn((Node)classVar, allOccurences, ClassVarAsgnNode.class)) continue;
                this.addClassVar(classVar);
                continue;
            }
            if (currentAttr instanceof ClassVarAsgnNode) {
                this.addClassVarAsgn((ClassVarAsgnNode)currentAttr);
                continue;
            }
            System.out.println(String.valueOf(Messages.FieldProvider_UnexpectedNodeOfType) + currentAttr.getClass() + Messages.FieldProvider_RetrievedAsField + currentAttr.toString());
        }
    }

    private void addClassVarAsgn(ClassVarAsgnNode classVarAsgnNode) {
        String name = FieldItem.fieldName(classVarAsgnNode.getName());
        this.initNameList(name);
        ArrayList<FieldItem> fieldList = this.fields.get(name);
        fieldList.add(new ClassVarAsgnFieldItem(classVarAsgnNode));
    }

    private void addClassVar(ClassVarNode classVarNode) {
        String name = FieldItem.fieldName(classVarNode.getName());
        this.initNameList(name);
        ArrayList<FieldItem> fieldList = this.fields.get(name);
        fieldList.add(new ClassVarFieldItem(classVarNode));
    }

    private void initAccessors(ClassNodeWrapper classWrapper) {
        for (AttrAccessorNodeWrapper currentAccessor : classWrapper.getAccessorNodes()) {
            String name = FieldItem.fieldName(currentAccessor.getAttrName());
            this.initNameList(name);
            ArrayList<FieldItem> itemList = this.fields.get(name);
            for (FCallNode accessorPart : currentAccessor.getAccessorNodes()) {
                ArrayNode arrayNode = (ArrayNode)accessorPart.getArgsNode();
                for (Object actObj : arrayNode.childNodes()) {
                    SymbolNode aktSymbol = (SymbolNode)actObj;
                    if (!name.equals(aktSymbol.getName())) continue;
                    itemList.add(new AttrFieldItem(aktSymbol));
                }
            }
        }
    }

    private void initAttrs(ClassNodeWrapper classWrapper) {
        Collection<Node> allOccurences = classWrapper.getInstFieldOccurences();
        for (Node currentAttr : allOccurences) {
            if (currentAttr instanceof SymbolNode) {
                this.addAttr((SymbolNode)currentAttr);
                continue;
            }
            if (currentAttr instanceof InstVarNode) {
                InstVarNode instVar = (InstVarNode)currentAttr;
                if (this.isVarSubNodeOfAsgn((Node)instVar, allOccurences, InstAsgnNode.class)) continue;
                this.addInstVar(instVar);
                continue;
            }
            if (currentAttr instanceof InstAsgnNode) {
                this.addInstAsgn((InstAsgnNode)currentAttr);
                continue;
            }
            System.out.println(String.valueOf(Messages.FieldProvider_UnexpectedNodeOfType) + currentAttr.getClass() + Messages.FieldProvider_RetrievedAsAttribute + currentAttr.toString());
        }
    }

    private boolean isVarSubNodeOfAsgn(Node instVar, Collection<Node> allNodes, Class kind) {
        for (Node currentNode : allNodes) {
            if (!currentNode.getClass().isAssignableFrom(kind) || !currentNode.getPosition().getFile().equals(instVar.getPosition().getFile()) || !SelectionNodeProvider.nodeContainsPosition(currentNode, instVar.getPosition().getStartOffset())) continue;
            return true;
        }
        return false;
    }

    private void addInstAsgn(InstAsgnNode currentAttr) {
        String name = FieldItem.fieldName(currentAttr.getName());
        this.initNameList(name);
        ArrayList<FieldItem> fieldList = this.fields.get(name);
        fieldList.add(new InstAsgnFieldItem(currentAttr));
    }

    private void addInstVar(InstVarNode instVar) {
        String name = FieldItem.fieldName(instVar.getName());
        this.initNameList(name);
        ArrayList<FieldItem> varList = this.fields.get(name);
        varList.add(new InstVarFieldItem(instVar));
    }

    private void initNameList(String name) {
        if (!this.fields.containsKey(name)) {
            this.fields.put(name, new ArrayList());
        }
    }

    private void addAttr(SymbolNode symbol) {
        String name = FieldItem.fieldName(symbol.getName());
        this.initNameList(name);
        ArrayList<FieldItem> attrList = this.fields.get(name);
        attrList.add(new AttrFieldItem(symbol));
    }

    public ArrayList<FieldItem> getFieldItems(String fieldName, boolean concernsClassField) {
        ArrayList<FieldItem> matchingItems = new ArrayList<FieldItem>();
        for (FieldItem currentItem : this.fields.get(fieldName)) {
            if (currentItem.concernsClassField() != concernsClassField) continue;
            matchingItems.add(currentItem);
        }
        return matchingItems;
    }

    public Collection<String> getFieldNames() {
        HashSet<String> names = new HashSet<String>((Collection)this.fields.keySet());
        return names;
    }

    public FieldItem getNameAtPosition(int caretPosition, String fileName) {
        for (String currentName : this.fields.keySet()) {
            for (FieldItem currentItem : this.fields.get(currentName)) {
                if (!currentItem.getFieldNode().getPosition().getFile().equals(fileName) || !SelectionNodeProvider.nodeContainsPosition(currentItem.getFieldNode(), caretPosition)) continue;
                return currentItem;
            }
        }
        return null;
    }
}

