/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamefield;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.FieldCallItem;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.FieldItem;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstVarAccessesFinder {
    public static Collection<FieldItem> find(IDocumentProvider document, String selectedName) {
        ArrayList<FieldItem> fieldCallNodes = new ArrayList<FieldItem>();
        Collection<Node> allNodes = document.getAllNodes();
        for (Node currentNode : allNodes) {
            if (!InstVarAccessesFinder.isPossibleCall(currentNode, document, selectedName)) continue;
            fieldCallNodes.add(new FieldCallItem((CallNode)currentNode));
        }
        return fieldCallNodes;
    }

    private static boolean isPossibleCall(Node candidateNode, IDocumentProvider document, String selectedName) {
        CallNode callNode;
        if (candidateNode instanceof CallNode && (callNode = (CallNode)candidateNode).getName().replaceAll("=", "").equals(selectedName)) {
            String fileName = callNode.getPosition().getFile();
            RootNode rootNode = document.getRootNode(fileName);
            try {
                SelectionNodeProvider.getSelectedClassNode((Node)rootNode, callNode.getPosition().getStartOffset());
            }
            catch (NoClassNodeException noClassNodeException) {
                return true;
            }
        }
        return false;
    }
}

