/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamefield;

import java.util.ArrayList;
import java.util.Collection;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.AttrFieldItem;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.FieldItem;
import org.rubypeople.rdt.refactoring.core.renamemethod.NodeSelector;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentWithIncluding;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.ui.ICheckboxListener;
import org.rubypeople.rdt.refactoring.ui.INewNameReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameFieldConfig
implements INewNameReceiver,
ICheckboxListener,
NodeSelector,
IRefactoringConfig {
    private IDocumentProvider docProvider;
    private int caretPosition;
    private String newName;
    private String selectedName;
    private ClassNodeWrapper wholeClassNode;
    private FieldProvider fieldProvider;
    private boolean doRenameAccessorMethods;
    private boolean doRenameAccessors = true;
    private Collection<? extends INodeWrapper> possibleCalls;
    private Collection<? extends INodeWrapper> selectedCalls;
    private FieldItem selectedItem;

    public RenameFieldConfig(IDocumentProvider docProvider, int caretPosition) {
        this.docProvider = docProvider;
        this.caretPosition = caretPosition;
        this.possibleCalls = new ArrayList<INodeWrapper>();
        this.selectedCalls = new ArrayList<INodeWrapper>();
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    @Override
    public IDocumentProvider getDocumentProvider() {
        return this.docProvider;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getSelectedName() {
        return this.selectedName;
    }

    public ClassNodeWrapper getWholeClassNode() {
        return this.wholeClassNode;
    }

    public Collection<String> getFieldNames() {
        return this.fieldProvider.getFieldNames();
    }

    public boolean hasSelectedName() {
        return this.selectedName != null;
    }

    public boolean hasWholeClassNode() {
        return this.wholeClassNode != null;
    }

    public FieldProvider getFieldProvider() {
        return this.fieldProvider;
    }

    public boolean doRenameAccessorMethods() {
        return this.doRenameAccessorMethods;
    }

    public void setDoRenameAccessorMethods(boolean doRenameAccessorMethods) {
        this.doRenameAccessorMethods = doRenameAccessorMethods;
    }

    @Override
    public void setChecked(boolean checked) {
        this.setDoRenameAccessorMethods(checked);
    }

    public boolean concernsClassField() {
        return this.selectedItem.concernsClassField();
    }

    public boolean hasSelectedItem() {
        return this.selectedItem != null;
    }

    public void setSelectedItem(FieldItem selectedItem) {
        this.selectedItem = selectedItem;
    }

    public FieldItem getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public Collection<? extends INodeWrapper> getPossibleCalls() {
        return this.possibleCalls;
    }

    @Override
    public Collection<? extends INodeWrapper> getSelectedCalls() {
        if (this.doRenameAccessors) {
            return this.selectedCalls;
        }
        ArrayList<INodeWrapper> nodes = new ArrayList<INodeWrapper>();
        for (INodeWrapper iNodeWrapper : this.selectedCalls) {
            if (iNodeWrapper instanceof AttrFieldItem) continue;
            nodes.add(iNodeWrapper);
        }
        return nodes;
    }

    @Override
    public void setPossibleCalls(Collection<? extends INodeWrapper> possibleCalls) {
        this.possibleCalls = possibleCalls;
    }

    @Override
    public void setSelectedCalls(Collection<? extends INodeWrapper> selectedCalls) {
        this.selectedCalls = selectedCalls;
    }

    public boolean isDoRenameAccessors() {
        return this.doRenameAccessors;
    }

    public void setDoRenameAccessors(boolean doRenameAccessors) {
        this.doRenameAccessors = doRenameAccessors;
    }

    public void setDocProvider(DocumentWithIncluding docProvider) {
        this.docProvider = docProvider;
    }

    public void setWholeClassNode(ClassNodeWrapper wholeClassNode) {
        this.wholeClassNode = wholeClassNode;
    }

    public void setFieldProvider(FieldProvider fieldProvider) {
        this.fieldProvider = fieldProvider;
    }

    public void setSelectedName(String selectedName) {
        this.selectedName = selectedName;
    }

    @Override
    public void setDocumentProvider(IDocumentProvider doc) {
        this.docProvider = doc;
    }
}

