/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamelocal;

import java.util.ArrayList;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.renamelocal.IAbortCondition;
import org.rubypeople.rdt.refactoring.core.renamelocal.VariableRenamer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicVariableRenamer
extends VariableRenamer {
    public DynamicVariableRenamer(String oldName, String newName, IAbortCondition abort) {
        super(oldName, newName, abort);
    }

    @Override
    public ArrayList<Node> replaceVariableNamesInNode(Node n, String[] localNames) {
        ArrayList<Node> renamed = new ArrayList<Node>();
        if (n instanceof MethodDefNode) {
            n = ((MethodDefNode)n).getBodyNode();
        } else if (n instanceof IterNode) {
            renamed.addAll(this.replaceVariableNames(((IterNode)n).getVarNode()));
            renamed.addAll(this.replaceVariableNames(((IterNode)n).getBodyNode()));
        }
        renamed.addAll(this.replaceVariableNames(n));
        return renamed;
    }

    public ArrayList<Node> replaceVariableNames(Node n) {
        ArrayList<Node> renamedNodes = new ArrayList<Node>();
        if (this.abort.abort(n)) {
            return renamedNodes;
        }
        if (n instanceof INameNode && ((INameNode)n).getName().equals(this.oldName)) {
            if (n instanceof DVarNode) {
                ((DVarNode)n).setName(this.newName);
            } else if (n instanceof DAsgnNode) {
                ((DAsgnNode)n).setName(this.newName);
                this.replaceVariableNames(n);
            }
            renamedNodes.add(n);
            return renamedNodes;
        }
        for (Object node : n.childNodes()) {
            renamedNodes.addAll(this.replaceVariableNames((Node)node));
        }
        return renamedNodes;
    }
}

