/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamelocal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.refactoring.core.renamelocal.Messages;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalConfig;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalEditProvider;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;

public class LocalVariableRenamer {
    private final DocumentProvider doc;
    private final String from;
    private final String to;

    public LocalVariableRenamer(DocumentProvider doc, String from, String to) {
        this.doc = doc;
        this.from = from;
        this.to = to;
    }

    public TextEdit getEdit() {
        RenameLocalConfig config = new RenameLocalConfig(this.doc, 0);
        new RenameLocalConditionChecker(config);
        RenameLocalEditProvider editProvider = new RenameLocalEditProvider(config);
        editProvider.setSelectedVariableName(this.from);
        editProvider.setNewVariableName(this.to);
        return editProvider.getEdit(this.doc.getActiveFileContent());
    }

    public DocumentProvider rename() {
        return LocalVariableRenamer.applyEdit(this.doc, this.getEdit());
    }

    public static StringDocumentProvider applyEdit(DocumentProvider doc, TextEdit edit) {
        Document result;
        block4: {
            result = new Document(doc.getActiveFileContent());
            try {
                edit.apply((IDocument)result);
            }
            catch (MalformedTreeException malformedTreeException) {
                assert (false);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return new StringDocumentProvider(String.valueOf(Messages.LocalVariableRenamer_Modified) + doc.getActiveFileName(), result.get());
    }
}

