/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamelocal;

import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalEditProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;

public class RenameLocalConfig
implements IRefactoringConfig {
    private IDocumentProvider docProvider;
    private int caretPosition;
    private Node selectedNode;
    private Node selectedMethod;
    private String[] localNames;
    private RenameLocalEditProvider editProvider;

    public RenameLocalConfig(IDocumentProvider docProvider, int caretPosition) {
        this.docProvider = docProvider;
        this.caretPosition = caretPosition;
    }

    public String getSelectedNodeName() {
        if (this.selectedNode instanceof INameNode) {
            return ((INameNode)this.selectedNode).getName();
        }
        if (this.selectedNode == null && this.selectedMethod instanceof MethodDefNode) {
            return this.localNames[((MethodDefNode)this.selectedMethod).getArgsNode().getRestArg()];
        }
        return "";
    }

    public IDocumentProvider getDocumentProvider() {
        return this.docProvider;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public boolean hasSelectedMethod() {
        return this.selectedMethod != null;
    }

    public boolean hasLocalNames() {
        return this.localNames.length > 2;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public Node getSelectedMethod() {
        return this.selectedMethod;
    }

    public String[] getLocalNames() {
        return this.localNames;
    }

    public void setLocalVariablesEditProvider(RenameLocalEditProvider editProvider) {
        this.editProvider = editProvider;
    }

    public RenameLocalEditProvider getRenameEditProvider() {
        return this.editProvider;
    }

    public void setSelectedNode(Node selectedNode) {
        this.selectedNode = selectedNode;
    }

    public void setSelectedMethod(Node selectedMethod) {
        this.selectedMethod = selectedMethod;
    }

    public void setLocalNames(String[] localNames) {
        this.localNames = (String[])localNames.clone();
    }

    public boolean hasSelectedNode() {
        return this.selectedNode != null;
    }

    public void setDocumentProvider(IDocumentProvider docProvider) {
        this.docProvider = docProvider;
    }
}

