/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamelocal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.renamelocal.DynamicVariableRenamer;
import org.rubypeople.rdt.refactoring.core.renamelocal.IAbortCondition;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalConfig;
import org.rubypeople.rdt.refactoring.core.renamelocal.SingleLocalVariableEdit;
import org.rubypeople.rdt.refactoring.core.renamelocal.VariableNameProvider;
import org.rubypeople.rdt.refactoring.core.renamelocal.VariableRenamer;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiEditProvider;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameLocalEditProvider
extends MultiEditProvider
implements Observer {
    private String selectedVariableName = "";
    private String newVariableName = "";
    private final RenameLocalConfig config;

    public RenameLocalEditProvider(RenameLocalConfig config) {
        this.config = config;
        config.setLocalVariablesEditProvider(this);
    }

    public void setSelectedVariableName(String name) {
        this.selectedVariableName = name;
    }

    public String getSelectedVariableName() {
        return this.selectedVariableName;
    }

    public void setNewVariableName(String name) {
        this.newVariableName = name;
    }

    public String getNewVariableName() {
        return this.newVariableName;
    }

    private ArrayList<Node> renameVariables() {
        VariableRenamer renamer = null;
        renamer = this.config.getSelectedNode() instanceof DVarNode || this.config.getSelectedNode() instanceof DAsgnNode ? new DynamicVariableRenamer(this.selectedVariableName, this.newVariableName, new AbortOnScope()) : new VariableRenamer(this.selectedVariableName, this.newVariableName, new AbortOnMethodDef());
        ArrayList<Node> changedNodes = ((VariableRenamer)renamer).replaceVariableNamesInNode(this.config.getSelectedMethod(), this.config.getLocalNames());
        return changedNodes;
    }

    @Override
    public void update(Observable subject, Object arg1) {
        if (subject instanceof VariableNameProvider) {
            this.setSelectedVariableName(((VariableNameProvider)subject).getSelected());
            this.setNewVariableName(((VariableNameProvider)subject).getName());
        }
    }

    @Override
    protected Collection<EditProvider> getEditProviders() {
        ArrayList<EditProvider> edits = new ArrayList<EditProvider>();
        for (Node n : this.renameVariables()) {
            edits.add(new SingleLocalVariableEdit(n, this.config.getLocalNames()));
        }
        return edits;
    }

    private static final class AbortOnMethodDef
    implements IAbortCondition {
        private AbortOnMethodDef() {
        }

        public boolean abort(Node currentNode) {
            return currentNode instanceof MethodDefNode;
        }
    }

    private static final class AbortOnScope
    implements IAbortCondition {
        private AbortOnScope() {
        }

        public boolean abort(Node currentNode) {
            return NodeUtil.hasScope(currentNode);
        }
    }
}

