/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamemethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.VCallNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldRenameEditProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.FieldItem;
import org.rubypeople.rdt.refactoring.core.renamemethod.MethodRenameEditProvider;
import org.rubypeople.rdt.refactoring.core.renamemethod.NodeSelector;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConfig;
import org.rubypeople.rdt.refactoring.core.renamemethod.methoditems.CallCandidateItem;
import org.rubypeople.rdt.refactoring.core.renamemethod.methoditems.MethodNameArgumentItem;
import org.rubypeople.rdt.refactoring.core.renamemethod.methoditems.SymbolItem;
import org.rubypeople.rdt.refactoring.editprovider.FileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiFileEditProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodRenamer
implements IMultiFileEditProvider {
    private RenameMethodConfig config;

    public Collection<String> getAllMethodsFromClass() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.config.getSelectedClass() != null) {
            for (MethodNodeWrapper method : this.config.getSelectedClass().getMethods()) {
                names.add(method.getName());
            }
        }
        return names;
    }

    public MethodRenamer(RenameMethodConfig config) {
        this.config = config;
        Collection<INodeWrapper> probableClass = this.getCallCandidatesInClass();
        probableClass.addAll(this.getSubsequentCalls());
        probableClass.addAll(config.getSelectedCalls());
        config.setSelectedCalls(probableClass);
    }

    @Override
    public Collection<FileMultiEditProvider> getFileEditProviders() {
        MultiFileEditProvider fileEdits = new MultiFileEditProvider();
        this.addDefinitionRenamer(fileEdits);
        this.addCallRenamers(fileEdits);
        if (!this.config.getTargetMethod().isClassMethod()) {
            this.addSymbolRenamers(fileEdits);
        }
        return fileEdits.getFileEditProviders();
    }

    private void addSymbolRenamers(MultiFileEditProvider fileEdits) {
        if (this.config.getTargetMethod().isClassMethod()) {
            return;
        }
        String file = this.config.getDocumentProvider().getActiveFileName();
        for (SymbolNode currentNode : this.getSymbolCandidatesInClass()) {
            this.addSymbolRenamer(fileEdits, file, currentNode, this.config.getNewName());
        }
    }

    private void addSymbolRenamer(MultiFileEditProvider fileEdits, String file, SymbolNode currentNode, String name) {
        SymbolItem currentItem = new SymbolItem(currentNode);
        fileEdits.addEditProvider(new FileEditProvider(file, new MethodRenameEditProvider(currentItem, name)));
    }

    private void addCallRenamers(MultiFileEditProvider fileEdits) {
        for (INodeWrapper iNodeWrapper : this.config.getSelectedCalls()) {
            String file = iNodeWrapper.getWrappedNode().getPosition().getFile();
            String newName = this.config.getNewName();
            if (iNodeWrapper instanceof MethodCallNodeWrapper) {
                CallCandidateItem candidateItem = new CallCandidateItem((MethodCallNodeWrapper)iNodeWrapper);
                fileEdits.addEditProvider(new FileEditProvider(file, new MethodRenameEditProvider(candidateItem, newName)));
                continue;
            }
            if (!this.config.renameFields()) continue;
            if (this.config.getTargetMethod().isWriter()) {
                newName = newName.replace("=", "");
            }
            FieldRenameEditProvider currentRenameProvider = new FieldRenameEditProvider((FieldItem)iNodeWrapper, newName);
            fileEdits.addEditProvider(new FileEditProvider(file, currentRenameProvider));
        }
    }

    private void addDefinitionRenamer(MultiFileEditProvider fileEdits) {
        if (this.config.getSelectedClass() == null || this.config.getTargetMethod().isClassMethod()) {
            String file = this.config.getDocumentProvider().getActiveFileName();
            MethodNameArgumentItem argumentItem = new MethodNameArgumentItem(this.config.getTargetMethod().getWrappedNode().getNameNode());
            fileEdits.addEditProvider(new FileEditProvider(file, new MethodRenameEditProvider(argumentItem, this.config.getNewName())));
        } else {
            for (ClassNodeWrapper currentClassNode : this.findRelatedClasses()) {
                MethodNodeWrapper currentMethodDef = currentClassNode.getMethod(this.config.getTargetMethod().getName());
                if (currentMethodDef == null) continue;
                String currentFile = currentMethodDef.getPosition().getFile();
                this.addMethodNameRenamer(fileEdits, currentMethodDef, currentFile, this.config.getNewName());
            }
        }
        if (this.config.getTargetMethod().isAccessor() && this.config.renameFields()) {
            String newName;
            String theOtherAccessor;
            if (this.config.getTargetMethod().isReader()) {
                theOtherAccessor = String.valueOf(this.config.getTargetMethod().getName()) + "=";
                newName = String.valueOf(this.config.getNewName()) + "=";
            } else {
                theOtherAccessor = this.config.getTargetMethod().getName().replace("=", "");
                newName = this.config.getNewName().replace("=", "");
            }
            MethodNodeWrapper method = this.config.getSelectedClass().getMethod(theOtherAccessor);
            if (method != null) {
                this.addMethodNameRenamer(fileEdits, method, method.getPosition().getFile(), newName);
                for (SymbolNode node : method.getSymbolCandidatesInClass(this.config.getSelectedClass())) {
                    this.addSymbolRenamer(fileEdits, method.getPosition().getFile(), node, newName);
                }
            }
        }
    }

    private void addMethodNameRenamer(MultiFileEditProvider fileEdits, MethodNodeWrapper currentMethodDef, String currentFile, String newName) {
        MethodNameArgumentItem argumentItem = new MethodNameArgumentItem(currentMethodDef.getWrappedNode().getNameNode());
        fileEdits.addEditProvider(new FileEditProvider(currentFile, new MethodRenameEditProvider(argumentItem, newName)));
    }

    private ArrayList<ClassNodeWrapper> findRelatedClasses() {
        ClassNodeProvider projectClassProvider = this.config.getDocumentProvider().getProjectClassNodeProvider();
        ArrayList<ClassNodeWrapper> relatedClasses = new ArrayList<ClassNodeWrapper>();
        relatedClasses.addAll(projectClassProvider.getClassAndAllSuperClassesFor(this.config.getSelectedClass().getName()));
        relatedClasses.addAll(projectClassProvider.getSubClassesOf(this.config.getSelectedClass().getName()));
        return relatedClasses;
    }

    public NodeSelector getConfig() {
        return this.config;
    }

    public Collection<INodeWrapper> getCallCandidatesInClass() {
        ArrayList<INodeWrapper> callCandidates = new ArrayList<INodeWrapper>();
        if (this.config.getSelectedClass() != null) {
            for (ClassNodeWrapper currentClass : this.findRelatedClasses()) {
                callCandidates.addAll(this.config.getTargetMethod().getCallCandidatesInClass(currentClass));
            }
        }
        return callCandidates;
    }

    public Collection<SymbolNode> getSymbolCandidatesInClass() {
        return this.config.getTargetMethod().getSymbolCandidatesInClass(this.config.getSelectedClass());
    }

    public Collection<MethodCallNodeWrapper> getSubsequentCalls() {
        RootNode fileRoot = this.config.getDocumentProvider().getActiveFileRootNode();
        int methodEndPos = this.config.getTargetMethod().getWrappedNode().getPosition().getEndOffset();
        ArrayList<MethodCallNodeWrapper> subsequentCalls = new ArrayList<MethodCallNodeWrapper>();
        if (SelectionNodeProvider.getSelectedNodeOfType((Node)fileRoot, methodEndPos, ClassNode.class, SClassNode.class) != null) {
            return subsequentCalls;
        }
        Collection<Node> callNodes = NodeProvider.getSubNodes((Node)fileRoot, CallNode.class, VCallNode.class, FCallNode.class);
        for (Node currentNode : callNodes) {
            MethodCallNodeWrapper currentCall;
            if (currentNode.getPosition().getStartOffset() < methodEndPos || !(currentCall = new MethodCallNodeWrapper(currentNode)).getName().equals(this.config.getTargetMethod().getName()) || this.hasDefsInEnclosingClass(currentCall, (Node)fileRoot)) continue;
            subsequentCalls.add(currentCall);
        }
        return subsequentCalls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasDefsInEnclosingClass(MethodCallNodeWrapper currentCall, Node rootNode) {
        int position = currentCall.getWrappedNode().getPosition().getStartOffset();
        try {
            MethodNodeWrapper currentMethod;
            ClassNodeWrapper classNode = SelectionNodeProvider.getSelectedClassNode(rootNode, position);
            Iterator<MethodNodeWrapper> iterator = classNode.getMethods().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                currentMethod = iterator.next();
            } while (!currentCall.getName().equals(currentMethod.getName()));
            return true;
        }
        catch (NoClassNodeException noClassNodeException) {
            return false;
        }
    }
}

