/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.splitlocal;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.renamelocal.DynamicVariableRenamer;
import org.rubypeople.rdt.refactoring.core.renamelocal.IAbortCondition;
import org.rubypeople.rdt.refactoring.core.renamelocal.SingleLocalVariableEdit;
import org.rubypeople.rdt.refactoring.core.renamelocal.VariableRenamer;
import org.rubypeople.rdt.refactoring.core.splitlocal.ISplittedVariableRenamer;
import org.rubypeople.rdt.refactoring.core.splitlocal.LocalVarUsage;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittedVariableRenamer
implements ISplittedVariableRenamer {
    private final Node scopeNode;

    public SplittedVariableRenamer(Node scopeNode) {
        this.scopeNode = scopeNode;
    }

    @Override
    public Collection<EditProvider> rename(Collection<LocalVarUsage> variables) {
        ArrayList<EditProvider> edits = new ArrayList<EditProvider>();
        for (LocalVarUsage localVarUsage : variables) {
            if (localVarUsage.getName().equals(localVarUsage.getNewName())) continue;
            VariableRenamer renamer = null;
            assert (localVarUsage.getNode() instanceof LocalAsgnNode || localVarUsage.getNode() instanceof DAsgnNode);
            if (localVarUsage.getNode() instanceof LocalAsgnNode) {
                renamer = this.createLocalVariableRenamer(localVarUsage);
            } else if (localVarUsage.getNode() instanceof DAsgnNode) {
                renamer = this.createDynamicVariableRenamer(localVarUsage);
            } else {
                return null;
            }
            ArrayList<Node> nodes = renamer.replaceVariableNamesInNode(this.scopeNode, NodeUtil.getScope(this.scopeNode).getVariables());
            for (Node node : nodes) {
                edits.add(new SingleLocalVariableEdit(node, NodeUtil.getScope(this.scopeNode).getVariables()));
            }
        }
        return edits;
    }

    private VariableRenamer createLocalVariableRenamer(LocalVarUsage localVarUsage) {
        VariableRenamer renamer = new VariableRenamer(localVarUsage.getName(), localVarUsage.getNewName(), new AbortOnOtherMethod(localVarUsage));
        return renamer;
    }

    private VariableRenamer createDynamicVariableRenamer(LocalVarUsage localVarUsage) {
        DynamicVariableRenamer renamer = new DynamicVariableRenamer(localVarUsage.getName(), localVarUsage.getNewName(), new AbortOnOtherScope(localVarUsage));
        return renamer;
    }

    private static final class AbortOnOtherMethod
    implements IAbortCondition {
        private final LocalVarUsage usage;

        private AbortOnOtherMethod(LocalVarUsage usage) {
            this.usage = usage;
        }

        public boolean abort(Node currentNode) {
            if (currentNode instanceof NewlineNode) {
                currentNode = ((NewlineNode)currentNode).getNextNode();
            }
            return currentNode instanceof MethodDefNode || currentNode.getPosition().getEndOffset() < this.usage.getFromPosition() || currentNode.getPosition().getStartOffset() > this.usage.getToPosition();
        }
    }

    private static final class AbortOnOtherScope
    implements IAbortCondition {
        private final LocalVarUsage usage;

        private AbortOnOtherScope(LocalVarUsage usage) {
            this.usage = usage;
        }

        public boolean abort(Node currentNode) {
            if (currentNode instanceof NewlineNode) {
                currentNode = ((NewlineNode)currentNode).getNextNode();
            }
            return NodeUtil.hasScope(currentNode) || currentNode.getPosition().getEndOffset() < this.usage.getFromPosition() || currentNode.getPosition().getStartOffset() > this.usage.getToPosition();
        }
    }
}

