/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.documentprovider;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringDocumentProvider
extends DocumentProvider {
    protected String document;
    protected String docName;
    protected Map<String, String> files;

    public StringDocumentProvider(String name, String document) {
        this.document = document;
        this.docName = name;
        this.files = new LinkedHashMap<String, String>();
        this.files.put(name, document);
    }

    public StringDocumentProvider(IDocumentProvider other) {
        this(other.getActiveFileName(), other.getActiveFileContent());
    }

    @Override
    public String getActiveFileContent() {
        return this.document;
    }

    @Override
    public String getActiveFileName() {
        return this.docName;
    }

    @Override
    public String getFileContent(String currentFileName) {
        return this.files.get(currentFileName);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.files.keySet();
    }

    public void addFile(String fileName, String fileContent) {
        this.files.put(fileName, fileContent);
    }
}

