/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.editprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProviderGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProviderGroups {
    private Map<String, EditProviderGroup> groups = new LinkedHashMap<String, EditProviderGroup>();

    public void add(String groupName, EditProvider editProvider) {
        EditProviderGroup group;
        if (this.groups.containsKey(groupName)) {
            group = this.groups.get(groupName);
        } else {
            group = new EditProviderGroup();
            this.groups.put(groupName, group);
        }
        group.add(editProvider);
    }

    public void add(String groupName, Collection<EditProvider> editProviders) {
        for (EditProvider provider : editProviders) {
            this.add(groupName, provider);
        }
    }

    public boolean hasGroup(String name) {
        return this.groups.containsKey(name);
    }

    public Collection<EditProvider> getGroup(String groupName) {
        return this.groups.get(groupName).getEditProviders();
    }

    public Collection<EditProvider> getAllEditProviders() {
        ArrayList<EditProvider> providers = new ArrayList<EditProvider>();
        for (EditProviderGroup group : this.groups.values()) {
            providers.addAll(group.getEditProviders());
        }
        return providers;
    }
}

