/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.RestArgNode;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsNodeWrapper
implements INodeWrapper {
    private ArgsNode argsNode;
    private Collection<String> argumentNames;

    public ArgsNodeWrapper(ArgsNode argsNode) {
        this.argsNode = argsNode;
        this.argumentNames = new ArrayList<String>();
        if (this.hasArgs()) {
            ListNode list = argsNode.getArgs();
            for (Object obj : list.childNodes()) {
                if (!(obj instanceof ArgumentNode)) continue;
                this.argumentNames.add(((ArgumentNode)obj).getName());
            }
        }
    }

    public String getArgsListAsString() {
        if (!this.hasArgs()) {
            return "";
        }
        StringBuilder argList = new StringBuilder();
        for (String argName : this.argumentNames) {
            argList.append(String.valueOf(argName) + ", ");
        }
        return String.valueOf(' ') + argList.substring(0, argList.length() - 2);
    }

    public Collection<String> getArgsList() {
        return this.argumentNames;
    }

    public boolean hasArgs() {
        return this.argsNode.getRequiredArgsCount() != 0 || this.argsNode.getOptArgs() != null || this.argsNode.getBlockArgNode() != null || this.argsNode.getRestArg() > 0;
    }

    public ListNode getOptArgs() {
        return this.argsNode.getOptArgs();
    }

    public BlockArgNode getBlockArgNode() {
        return this.argsNode.getBlockArgNode();
    }

    public int getRestArg() {
        return this.argsNode.getRestArg();
    }

    public ArgsNode getWrappedNode() {
        return this.argsNode;
    }

    public ArgsNodeWrapper cloneWithNewArgName(String newArgName) {
        ArrayList<String> newArgNames = new ArrayList<String>(this.argumentNames);
        newArgNames.add(newArgName);
        ArgsNode tempArgsNode = NodeFactory.createArgsNode(newArgNames.toArray(new String[newArgNames.size()]), this.argsNode.getOptArgs(), this.argsNode.getRestArg(), (RestArgNode)this.argsNode.getRestArgNode(), this.argsNode.getBlockArgNode());
        return new ArgsNodeWrapper(tempArgsNode);
    }

    public boolean argsCountMatches(MethodCallNodeWrapper callNode) {
        int callArgs = callNode.getArgsCount();
        int minArgs = this.argsNode.getRequiredArgsCount();
        int maxArgs = minArgs + this.getOptArgsCount();
        if (this.argsNode.getRestArg() >= 0) {
            maxArgs = Integer.MAX_VALUE;
        }
        return callArgs >= minArgs && callArgs <= maxArgs;
    }

    private int getOptArgsCount() {
        if (this.getOptArgs() == null) {
            return 0;
        }
        return this.getOptArgs().size();
    }
}

