/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.SymbolNode;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.renamemodule.ModuleSpecifierWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNodeWrapper
implements INodeWrapper {
    private Collection<PartialClassNodeWrapper> partialClassNodes = new ArrayList<PartialClassNodeWrapper>();

    public ClassNodeWrapper(PartialClassNodeWrapper partialClassNode) {
        this.addPartialClassNode(partialClassNode);
    }

    public void addPartialClassNode(PartialClassNodeWrapper partialClassNode) {
        this.partialClassNodes.add(partialClassNode);
    }

    public Collection<FieldNodeWrapper> getFields() {
        ArrayList<FieldNodeWrapper> fields = new ArrayList<FieldNodeWrapper>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            fields.addAll(partialClassNode.getFields());
        }
        return fields;
    }

    public Collection<ModuleSpecifierWrapper> getIncludes() {
        ArrayList<ModuleSpecifierWrapper> fields = new ArrayList<ModuleSpecifierWrapper>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            fields.addAll(partialClassNode.getIncludeCalls());
        }
        return fields;
    }

    public Collection<MethodNodeWrapper> getMethods() {
        ArrayList<MethodNodeWrapper> methodNodes = new ArrayList<MethodNodeWrapper>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            methodNodes.addAll(partialClassNode.getMethods());
        }
        return methodNodes;
    }

    public boolean hasMethod(String name) {
        for (MethodNodeWrapper method : this.getMethods()) {
            if (!name.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    public PartialClassNodeWrapper getFirstPartialClassNode() {
        return this.partialClassNodes.iterator().next();
    }

    public String getName() {
        return this.getFirstPartialClassNode().getClassName();
    }

    public String getSuperClassName() {
        return this.getFirstPartialClassNode().getSuperClassName();
    }

    public MethodNodeWrapper getConstructorNode() {
        Collection<MethodNodeWrapper> constructors = this.getExistingConstructors();
        if (constructors.isEmpty()) {
            return new MethodNodeWrapper((MethodDefNode)NodeFactory.createDefaultConstructor(), this);
        }
        return constructors.toArray(new MethodNodeWrapper[constructors.size()])[constructors.size() - 1];
    }

    public Collection<MethodNodeWrapper> getExistingConstructors() {
        ArrayList<MethodNodeWrapper> constructors = new ArrayList<MethodNodeWrapper>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            constructors.addAll(partialClassNode.getExistingConstructors());
        }
        return constructors;
    }

    public boolean hasConstructor() {
        return !this.getExistingConstructors().isEmpty();
    }

    public Collection<Node> getAttrNodes() {
        ArrayList<Node> attrNodes = new ArrayList<Node>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            attrNodes.addAll(partialClassNode.getAttrNodes());
        }
        return attrNodes;
    }

    public Collection<AttrAccessorNodeWrapper> getAccessorNodes() {
        ArrayList<AttrAccessorNodeWrapper> accessorNodes = new ArrayList<AttrAccessorNodeWrapper>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            accessorNodes.addAll(partialClassNode.getAccessorNodes());
        }
        return accessorNodes;
    }

    public Collection<PartialClassNodeWrapper> getPartialClassNodes() {
        return this.partialClassNodes;
    }

    public Collection<PartialClassNodeWrapper> getPartialClassNodesOfFile(String file) {
        ArrayList<PartialClassNodeWrapper> matchingPartialClasses = new ArrayList<PartialClassNodeWrapper>();
        for (PartialClassNodeWrapper currentClassPart : this.partialClassNodes) {
            String fileOfClassPart = currentClassPart.getFile();
            if (!fileOfClassPart.equals(file)) continue;
            matchingPartialClasses.add(currentClassPart);
        }
        return matchingPartialClasses;
    }

    public Collection<Node> getInstFieldOccurences() {
        ArrayList<Node> allFieldOccuences = new ArrayList<Node>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            allFieldOccuences.addAll(partialClassNode.getInstFieldOccurences());
        }
        return allFieldOccuences;
    }

    public Collection<Node> getClassFieldOccurences() {
        ArrayList<Node> classFieldOccuences = new ArrayList<Node>();
        for (PartialClassNodeWrapper partialClassNode : this.partialClassNodes) {
            classFieldOccuences.addAll(partialClassNode.getClassFieldOccurences());
        }
        return classFieldOccuences;
    }

    public Collection<MethodCallNodeWrapper> getMethodCalls(MethodDefNode decoratedNode) {
        ArrayList<MethodCallNodeWrapper> calls = new ArrayList<MethodCallNodeWrapper>();
        for (PartialClassNodeWrapper classPart : this.partialClassNodes) {
            calls.addAll(classPart.getMethodCalls(decoratedNode));
        }
        return calls;
    }

    public Collection<MethodCallNodeWrapper> getMethodCallNodes() {
        ArrayList<MethodCallNodeWrapper> methodCalls = new ArrayList<MethodCallNodeWrapper>();
        for (PartialClassNodeWrapper classPart : this.partialClassNodes) {
            methodCalls.addAll(classPart.getMethodCallNodes());
        }
        return methodCalls;
    }

    public Collection<SymbolNode> getMethodSymbols(MethodDefNode decoratedNode) {
        ArrayList<SymbolNode> symbols = new ArrayList<SymbolNode>();
        for (PartialClassNodeWrapper classPart : this.partialClassNodes) {
            symbols.addAll(classPart.getMethodSymbols(decoratedNode));
        }
        return symbols;
    }

    public VisibilityNodeWrapper.METHOD_VISIBILITY getMethodVisibility(MethodNodeWrapper methodNode) {
        if (methodNode.isClassMethod()) {
            return VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC;
        }
        VisibilityNodeWrapper methodVisibility = this.getMethodVisibilityNode(methodNode);
        if (methodVisibility != null) {
            return methodVisibility.getVisibility();
        }
        PartialClassNodeWrapper affectedClassPart = this.getPartContainingMethod(methodNode);
        return affectedClassPart.getPosVisibility(methodNode.getWrappedNode().getPosition().getStartOffset());
    }

    public VisibilityNodeWrapper getMethodVisibilityNode(MethodNodeWrapper methodNode) {
        PartialClassNodeWrapper affectedClassPart = this.getPartContainingMethod(methodNode);
        Collection<VisibilityNodeWrapper> visibilities = affectedClassPart.getMethodVisibilityNodes();
        for (VisibilityNodeWrapper aktNode : visibilities) {
            if (!aktNode.containsMethod(methodNode)) continue;
            return aktNode;
        }
        return null;
    }

    public Collection<VisibilityNodeWrapper> getMethodVisibilityNodes() {
        ArrayList<VisibilityNodeWrapper> visibilites = new ArrayList<VisibilityNodeWrapper>();
        for (PartialClassNodeWrapper classPart : this.partialClassNodes) {
            visibilites.addAll(classPart.getMethodVisibilityNodes());
        }
        return visibilites;
    }

    private PartialClassNodeWrapper getPartContainingMethod(MethodNodeWrapper methodNode) {
        for (PartialClassNodeWrapper classPart : this.partialClassNodes) {
            for (MethodNodeWrapper aktMethodNode : classPart.getMethods()) {
                if (!aktMethodNode.equals(methodNode)) continue;
                return classPart;
            }
        }
        return null;
    }

    public MethodNodeWrapper getMethod(String searchedMethodName) {
        Collection<MethodNodeWrapper> methodNodes = this.getMethods();
        MethodNodeWrapper lastMethod = null;
        for (MethodNodeWrapper aktMethod : methodNodes) {
            if (!aktMethod.getName().equals(searchedMethodName)) continue;
            lastMethod = aktMethod;
        }
        return lastMethod;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.partialClassNodes == null ? 0 : this.partialClassNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassNodeWrapper) {
            ClassNodeWrapper otherClassNode = (ClassNodeWrapper)obj;
            return this.getName().equals(otherClassNode.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean containsMethod(String searchedMethodName, boolean isClassMethod) {
        Collection<MethodNodeWrapper> methodNodes = this.getMethods();
        for (MethodNodeWrapper aktMethod : methodNodes) {
            if (isClassMethod && !aktMethod.isClassMethod() || !aktMethod.getName().equals(searchedMethodName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMethod(String searchedMethodName) {
        return this.containsMethod(searchedMethodName, false);
    }

    public PartialClassNodeWrapper getPartialClassNodeForFileName(String fileName) {
        for (PartialClassNodeWrapper aktPart : this.partialClassNodes) {
            if (!aktPart.getWrappedNode().getPosition().getFile().equals(fileName)) continue;
            return aktPart;
        }
        return null;
    }

    @Override
    public Node getWrappedNode() {
        return this.partialClassNodes.toArray(new PartialClassNodeWrapper[this.partialClassNodes.size()])[0].getWrappedNode();
    }

    public boolean containsField(String searchedFieldName) {
        for (FieldNodeWrapper aktFieldNode : this.getFields()) {
            if (!aktFieldNode.getName().equals(searchedFieldName)) continue;
            return true;
        }
        return false;
    }
}

