/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalNodeWrapper
implements INodeWrapper {
    public static final int INVALID_ID = -1;
    public static final int LOCAL_ASGN_VAR_NODE = 1;
    public static final int LOCAL_VAR_NODE = 2;
    public static final int D_VAR_NODE = 3;
    public static final int D_ASGN_NODE = 4;
    public static final Class[] LOCAL_NODES_CLASSES = new Class[]{LocalAsgnNode.class, LocalVarNode.class, DVarNode.class, DAsgnNode.class};
    private Node wrappedNode;
    private int nodeType;
    private Node valueNode;
    private String name;
    private int id = -1;

    public LocalNodeWrapper(Node node) {
        if (NodeUtil.nodeAssignableFrom(node, LocalVarNode.class)) {
            this.id = ((LocalVarNode)node).getIndex();
            this.name = ((LocalVarNode)node).getName();
            this.nodeType = 2;
        } else if (NodeUtil.nodeAssignableFrom(node, LocalAsgnNode.class)) {
            LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
            this.id = localAsgnNode.getIndex();
            this.name = localAsgnNode.getName();
            this.nodeType = 1;
            this.valueNode = localAsgnNode.getValueNode();
        } else if (NodeUtil.nodeAssignableFrom(node, DAsgnNode.class)) {
            DAsgnNode dAsgnNode = (DAsgnNode)node;
            this.name = dAsgnNode.getName();
            this.nodeType = 4;
            this.valueNode = dAsgnNode.getValueNode();
        } else if (NodeUtil.nodeAssignableFrom(node, DVarNode.class)) {
            DVarNode dVarNode = (DVarNode)node;
            this.name = dVarNode.getName();
            this.nodeType = 3;
        }
        this.wrappedNode = node;
    }

    @Override
    public Node getWrappedNode() {
        return this.wrappedNode;
    }

    public boolean hasValidId() {
        return this.id != -1;
    }

    public int getId() {
        return this.id;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public boolean hasValueNode() {
        return this.valueNode != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAsgnNode() {
        return this.nodeType == 1 || this.nodeType == 4;
    }

    public boolean isDVarNode() {
        return this.nodeType == 3 || this.nodeType == 4;
    }

    public void setName(String name) {
        if (this.nodeType != 2) {
            this.name = name;
        }
        if (NodeUtil.nodeAssignableFrom(this.wrappedNode, LocalVarNode.class)) {
            LocalVarNode localVarNode = (LocalVarNode)this.wrappedNode;
            localVarNode.setName(name);
        } else if (NodeUtil.nodeAssignableFrom(this.wrappedNode, LocalAsgnNode.class)) {
            LocalAsgnNode localAsgnNode = (LocalAsgnNode)this.wrappedNode;
            localAsgnNode.setName(name);
        } else if (NodeUtil.nodeAssignableFrom(this.wrappedNode, DAsgnNode.class)) {
            DAsgnNode dAsgnNode = (DAsgnNode)this.wrappedNode;
            dAsgnNode.setName(name);
        } else if (NodeUtil.nodeAssignableFrom(this.wrappedNode, DVarNode.class)) {
            DVarNode dVarNode = (DVarNode)this.wrappedNode;
            dVarNode.setName(name);
        }
    }

    public static String getLocalNodeName(LocalNodeWrapper node) {
        return node.getName();
    }

    public static Collection<LocalNodeWrapper> gatherLocalNodes(Node baseNode) {
        return LocalNodeWrapper.gatherLocalNodes(baseNode, LOCAL_NODES_CLASSES);
    }

    public static Collection<LocalNodeWrapper> gatherLocalVarNodes(Node baseNode) {
        return LocalNodeWrapper.gatherLocalNodes(baseNode, DVarNode.class, LocalVarNode.class);
    }

    public static Collection<LocalNodeWrapper> gatherLocalAsgnNodes(Node baseNode) {
        return LocalNodeWrapper.gatherLocalNodes(baseNode, DAsgnNode.class, LocalAsgnNode.class);
    }

    private static Collection<LocalNodeWrapper> gatherLocalNodes(Node baseNode, Class ... klasses) {
        ArrayList<LocalNodeWrapper> localNodes = new ArrayList<LocalNodeWrapper>();
        for (Node aktNode : NodeProvider.getSubNodes(baseNode, klasses)) {
            localNodes.add(new LocalNodeWrapper(aktNode));
        }
        return localNodes;
    }

    public static Collection<LocalNodeWrapper> createLocalNodes(Collection<Node> nodes) {
        ArrayList<LocalNodeWrapper> localNodes = new ArrayList<LocalNodeWrapper>();
        for (Node aktNode : nodes) {
            if (!NodeUtil.nodeAssignableFrom(aktNode, LOCAL_NODES_CLASSES)) continue;
            localNodes.add(new LocalNodeWrapper(aktNode));
        }
        return localNodes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.wrappedNode == null ? 0 : this.wrappedNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalNodeWrapper) {
            LocalNodeWrapper localNode = (LocalNodeWrapper)obj;
            return localNode.getWrappedNode().equals(this.getWrappedNode());
        }
        return false;
    }
}

