/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import org.jruby.ast.ClassNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

public class RealClassNodeWrapper
extends PartialClassNodeWrapper {
    private ClassNode classNode;

    public RealClassNodeWrapper(Node node) {
        super(node);
        this.classNode = (ClassNode)node;
    }

    public String getSuperClassName() {
        if (this.getClassName().equals("Object")) {
            return null;
        }
        Node superClassNode = this.classNode.getSuperNode();
        if (superClassNode instanceof INameNode) {
            return ((INameNode)superClassNode).getName();
        }
        return "Object";
    }

    public String getClassName() {
        if ("".equals(this.getModulePrefix())) {
            return this.classNode.getCPath().getName();
        }
        return String.valueOf(this.getModulePrefix()) + "::" + this.classNode.getCPath().getName();
    }

    public Node getClassBodyNode() {
        return this.classNode.getBodyNode();
    }

    public Node getDeclarationEndNode() {
        Node endDeclarationNode = this.classNode.getSuperNode();
        if (endDeclarationNode == null) {
            endDeclarationNode = this.classNode.getCPath();
        }
        return endDeclarationNode;
    }
}

