/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.SymbolNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisibilityNodeWrapper
implements INodeWrapper {
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String PRIVATE = "private";
    private FCallNode wrappedNode;

    public VisibilityNodeWrapper(FCallNode node) {
        this.wrappedNode = node;
    }

    public boolean containsMethod(MethodNodeWrapper methodNode) {
        Collection<String> methodNames = this.getMethodNames();
        String searchedMethodName = methodNode.getName();
        for (String aktMethodName : methodNames) {
            if (!aktMethodName.equals(searchedMethodName)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getMethodNames() {
        ArrayList<String> methods = new ArrayList<String>();
        if (NodeUtil.nodeAssignableFrom(this.wrappedNode.getArgsNode(), ArrayNode.class)) {
            ArrayNode arrayNode = (ArrayNode)this.wrappedNode.getArgsNode();
            for (Object aktObj : arrayNode.childNodes()) {
                if (!(aktObj instanceof SymbolNode)) continue;
                methods.add(((SymbolNode)aktObj).getName());
            }
        }
        return methods;
    }

    public METHOD_VISIBILITY getVisibility() {
        return VisibilityNodeWrapper.getVisibility(this.wrappedNode.getName());
    }

    public static METHOD_VISIBILITY getVisibility(String name) {
        if (name.equals(PUBLIC)) {
            return METHOD_VISIBILITY.PUBLIC;
        }
        if (name.equals(PROTECTED)) {
            return METHOD_VISIBILITY.PROTECTED;
        }
        if (name.equals(PRIVATE)) {
            return METHOD_VISIBILITY.PRIVATE;
        }
        return METHOD_VISIBILITY.NONE;
    }

    public ISourcePosition getPosition() {
        return this.wrappedNode.getPosition();
    }

    public static boolean isVisibilityString(String name) {
        return name.equals(PUBLIC) || name.equals(PROTECTED) || name.equals(PRIVATE);
    }

    public FCallNode getWrappedNode() {
        return this.wrappedNode;
    }

    public static String getVisibilityName(METHOD_VISIBILITY visibility) {
        if (METHOD_VISIBILITY.PUBLIC.equals((Object)visibility)) {
            return PUBLIC;
        }
        if (METHOD_VISIBILITY.PROTECTED.equals((Object)visibility)) {
            return PROTECTED;
        }
        if (METHOD_VISIBILITY.PRIVATE.equals((Object)visibility)) {
            return PRIVATE;
        }
        return "none";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum METHOD_VISIBILITY {
        PRIVATE,
        PROTECTED,
        PUBLIC,
        NONE;

    }
}

