/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.offsetprovider;

import java.util.List;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.IOffsetProvider;
import org.rubypeople.rdt.refactoring.util.FileHelper;

public abstract class OffsetProvider
implements IOffsetProvider {
    private String document;

    public OffsetProvider(String document) {
        this.document = document;
    }

    public abstract Node getInsertAfterNode();

    public int getOffset() {
        Node insertAfterNode = this.getInsertAfterNode();
        if (insertAfterNode == null) {
            return Integer.MAX_VALUE;
        }
        int lineNr = insertAfterNode.getPositionIncludingComments().getEndLine();
        int lineEndOffset = this.getLineEndOffset(lineNr);
        return lineEndOffset;
    }

    private int getLineEndOffset(int lineNr) {
        int pos = -1;
        int i = 0;
        while (i <= lineNr) {
            String lineDelimiter = FileHelper.getLineDelimiter(this.document);
            pos = this.document.indexOf(lineDelimiter, pos + 1);
            ++i;
        }
        if (pos == -1) {
            return this.document.length();
        }
        return pos;
    }

    protected Node getLastContentNode(PartialClassNodeWrapper classNode) {
        List childNodes = classNode.getClassBodyNode().childNodes();
        Node lastNode = (Node)childNodes.get(childNodes.size() - 1);
        return lastNode;
    }
}

