/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.refactoring.core.convertlocaltofield.LocalToFieldConverter;
import org.rubypeople.rdt.refactoring.ui.LabeledTextField;
import org.rubypeople.rdt.refactoring.ui.pages.ConverterPageParameters;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class ConvertLocalToFieldPage
extends RefactoringWizardPage {
    private static final String TITLE = Messages.ConvertTempToFieldPage_ConvertLocalVariableToField;
    private LocalToFieldConverter converter;
    private ConverterPageParameters pageParameters;

    public ConvertLocalToFieldPage(LocalToFieldConverter converter, ConverterPageParameters parameters) {
        super(TITLE);
        this.converter = converter;
        this.pageParameters = parameters;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 8;
        control.setLayout((Layout)layout);
        final LabeledTextField labeledText = new LabeledTextField(control, Messages.ConvertTempToFieldPage_FieldName, this.converter.getLocalVarName());
        GridData layoutData = new GridData(768);
        labeledText.setLayoutData(layoutData);
        labeledText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newName = labeledText.getText().getText();
                ConvertLocalToFieldPage.this.converter.setNewName(newName);
                this.checkInput(newName);
            }

            private void checkInput(String newName) {
                if (NameValidator.isValidLocalVariableName(newName)) {
                    ConvertLocalToFieldPage.this.setMessage(null);
                    ConvertLocalToFieldPage.this.setPageComplete(true);
                } else {
                    ConvertLocalToFieldPage.this.setMessage("'" + newName + Messages.ConvertTempToFieldPage_IsNotValid, 3);
                    ConvertLocalToFieldPage.this.setPageComplete(false);
                }
            }
        });
        this.initInitializeRadioGroup(control);
        final Button declareClassField = new Button(control, 32);
        GridData checkData = new GridData();
        declareClassField.setLayoutData((Object)checkData);
        declareClassField.setText(Messages.ConvertTempToFieldPage_DeclareAsClassField);
        declareClassField.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConvertLocalToFieldPage.this.converter.setIsClassField(declareClassField.getSelection());
            }
        });
    }

    private void initInitializeRadioGroup(Composite control) {
        Group initializeInGroup = new Group(control, 0);
        RowLayout radioGroupLayout = new RowLayout(512);
        initializeInGroup.setLayout((Layout)radioGroupLayout);
        initializeInGroup.setText(Messages.ConvertTempToFieldPage_InitializeIn);
        Button inCurrentMethod = new Button((Composite)initializeInGroup, 16);
        inCurrentMethod.setText(Messages.ConvertTempToFieldPage_CurrentMethod);
        inCurrentMethod.setEnabled(this.pageParameters.isInCurrentMethodRadioEnabled());
        this.addRadioListener(inCurrentMethod, 1);
        inCurrentMethod.setSelection(true);
        Button inClassConstructor = new Button((Composite)initializeInGroup, 16);
        inClassConstructor.setText(Messages.ConvertTempToFieldPage_ClassConstructor);
        inClassConstructor.setEnabled(this.pageParameters.isInClassConstructorRadioEnabled());
        this.addRadioListener(inClassConstructor, 2);
        GridData groupData = new GridData(768);
        initializeInGroup.setLayoutData((Object)groupData);
    }

    private void addRadioListener(Button button, final int initPlace) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConvertLocalToFieldPage.this.converter.setInitPlace(initPlace);
            }
        });
    }
}

