/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.rubypeople.rdt.refactoring.core.formatsource.EditableFormatHelper;
import org.rubypeople.rdt.refactoring.core.formatsource.PreviewGenerator;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;

public class FormatSourcePage
extends RefactoringWizardPage {
    private static final String title = "";
    private StyledText previewText;
    private EditableFormatHelper formatter;
    private PreviewGenerator previewGenererator;

    public FormatSourcePage(EditableFormatHelper formatter, PreviewGenerator previewGenerator) {
        super(title);
        this.setTitle(title);
        this.formatter = formatter;
        this.previewGenererator = previewGenerator;
    }

    private void createMethodsTab(TabFolder categoryTab) {
        TabItem methodsTabItem = this.createTabItem(categoryTab, Messages.FormatSourcePage_Methods);
        Composite optionComposite = this.createCompositeWithGridLayout((Composite)categoryTab);
        methodsTabItem.setControl((Control)optionComposite);
        Group callArgumentsGroup = this.createGroupWithGridLayout(optionComposite, Messages.FormatSourcePage_MethodCallArguments);
        final Button callArgumentsParanthesizeWhereNecessary = this.createButton((Composite)callArgumentsGroup, 16, Messages.FormatSourcePage_ParenthesizeWhereNecesary);
        callArgumentsParanthesizeWhereNecessary.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setAlwaysParanthesizeMethodCalls(!callArgumentsParanthesizeWhereNecessary.getEnabled());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button callArgumentsParanthesizeAlways = this.createButton((Composite)callArgumentsGroup, 16, Messages.FormatSourcePage_AlwaysParenthesize);
        callArgumentsParanthesizeAlways.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setAlwaysParanthesizeMethodCalls(callArgumentsParanthesizeAlways.getEnabled());
                FormatSourcePage.this.generatePreview();
            }
        });
        Group defArgumentsGroup = this.createGroupWithGridLayout(optionComposite, Messages.FormatSourcePage_MethodDefArguments);
        final Button defArgumentsParanthesizeWhereNecessary = this.createButton((Composite)defArgumentsGroup, 16, Messages.FormatSourcePage_ParenthesizeWhereNecesary);
        defArgumentsParanthesizeWhereNecessary.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setAlwaysParanthesizeMethodDefs(!defArgumentsParanthesizeWhereNecessary.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button defArgumentsParanthesizeAlways = this.createButton((Composite)defArgumentsGroup, 16, Messages.FormatSourcePage_AlwaysParenthesize);
        defArgumentsParanthesizeAlways.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setAlwaysParanthesizeMethodDefs(defArgumentsParanthesizeAlways.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button newlineBetweenClassBodyElements = this.createButton(optionComposite, 32, Messages.FormatSourcePage_NewlineBetweenClassElements);
        newlineBetweenClassBodyElements.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setNewlineBetweenClassBodyElements(newlineBetweenClassBodyElements.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
    }

    private void createBlocksTab(TabFolder categoryTab) {
        TabItem misc = this.createTabItem(categoryTab, Messages.FormatSourcePage_Blocks);
        Composite composite = this.createCompositeWithGridLayout((Composite)categoryTab);
        misc.setControl((Control)composite);
        final Button spaceBeforeIterBrackets = this.createButton(composite, 32, Messages.FormatSourcePage_SpaceBeforeIterBrackets);
        spaceBeforeIterBrackets.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpaceBeforeIterBrackets(spaceBeforeIterBrackets.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button spaceBeforeClosingIterBrackets = this.createButton(composite, 32, Messages.FormatSourcePage_SpaceBeforeClosingIterBracket);
        spaceBeforeClosingIterBrackets.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpaceBeforeClosingIterBrackets(spaceBeforeClosingIterBrackets.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button spaceBeforeIterVars = this.createButton(composite, 32, Messages.FormatSourcePage_SpaceBeforeIterVars);
        spaceBeforeIterVars.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpaceBeforeIterVars(spaceBeforeIterVars.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button spaceAfterIterVars = this.createButton(composite, 32, Messages.FormatSourcePage_SpaceAfterIterVars);
        spaceAfterIterVars.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpaceAfterIterVars(spaceAfterIterVars.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
    }

    private void createSpacesTab(TabFolder categoryTab) {
        TabItem spaces = this.createTabItem(categoryTab, Messages.FormatSourcePage_Spaces);
        Composite composite = this.createCompositeWithGridLayout((Composite)categoryTab);
        spaces.setControl((Control)composite);
        final Button spaceAfterComma = this.createButton(composite, 32, Messages.FormatSourcePage_SpaceAfterComma);
        spaceAfterComma.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpaceAfterCommaInListings(spaceAfterComma.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button spacesAroundHashAss = this.createButton(composite, 32, Messages.FormatSourcePage_SpacesAroundHashOperator);
        spacesAroundHashAss.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpacesAroundHashAssignment(spacesAroundHashAss.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button spacesAroundHashContent = this.createButton(composite, 32, Messages.FormatSourcePage_SpacesAroundHash);
        spacesAroundHashContent.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpacesBeforeAndAfterHashContent(spacesAroundHashContent.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        final Button spacesAroundAssignments = this.createButton(composite, 32, Messages.FormatSourcePage_SpacesAroundAssignment);
        spacesAroundAssignments.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setSpacesBeforeAndAfterAssignments(spacesAroundAssignments.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
    }

    private void createGeneralTab(TabFolder categoryTab) {
        TabItem spaces = this.createTabItem(categoryTab, Messages.FormatSourcePage_General);
        Composite composite = this.createCompositeWithGridLayout((Composite)categoryTab);
        spaces.setControl((Control)composite);
        Group callArgumentsGroup = this.createGroupWithGridLayout(composite, Messages.FormatSourcePage_Indentation);
        final Button tabInsteadOfSpaces = this.createButton((Composite)callArgumentsGroup, 32, Messages.FormatSourcePage_UseTab);
        tabInsteadOfSpaces.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setTabInsteadOfSpaces(tabInsteadOfSpaces.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        Composite indentationComposite = new Composite((Composite)callArgumentsGroup, 0);
        indentationComposite.setLayout((Layout)new RowLayout());
        final Spinner indentationSteps = new Spinner(indentationComposite, 2048);
        indentationSteps.setMinimum(0);
        indentationSteps.setMaximum(100);
        indentationSteps.setSelection(2);
        indentationSteps.setIncrement(1);
        indentationSteps.pack();
        indentationSteps.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormatSourcePage.this.formatter.setIndentationSteps(indentationSteps.getSelection());
                FormatSourcePage.this.generatePreview();
            }
        });
        Label label = new Label(indentationComposite, 0);
        label.setText(Messages.FormatSourcePage_IndentationSteps);
    }

    public void createControl(Composite parent) {
        SashForm mainSashForm = new SashForm(parent, 0);
        TabFolder categoryTab = new TabFolder((Composite)mainSashForm, 0);
        this.createGeneralTab(categoryTab);
        this.createMethodsTab(categoryTab);
        this.createSpacesTab(categoryTab);
        this.createBlocksTab(categoryTab);
        this.previewText = new StyledText((Composite)mainSashForm, 2824);
        this.generatePreview();
        parent.layout();
        this.setControl((Control)parent);
    }

    private void generatePreview() {
        this.previewText.setText(this.previewGenererator.getPreview(this.formatter));
    }

    private TabItem createTabItem(TabFolder parent, String name) {
        TabItem item = new TabItem(parent, 0);
        item.setText(name);
        return item;
    }

    private Composite createCompositeWithGridLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private GridData createFillingGrid() {
        GridData groupData = new GridData();
        groupData.verticalAlignment = 1;
        groupData.grabExcessHorizontalSpace = true;
        groupData.horizontalAlignment = 4;
        return groupData;
    }

    private Group createGroupWithGridLayout(Composite parent, String groupText) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)this.createFillingGrid());
        group.setText(groupText);
        return group;
    }

    private Button createButton(Composite parent, int style, String text) {
        Button button = new Button(parent, style | 0x4000);
        button.setText(text);
        return button;
    }
}

