/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.refactoring.core.inlinelocal.InlineLocalConfig;
import org.rubypeople.rdt.refactoring.core.inlinelocal.InlineLocalRefactoring;
import org.rubypeople.rdt.refactoring.ui.LabeledTextField;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class InlineLocalPage
extends RefactoringWizardPage {
    private InlineLocalConfig config;
    private int occurencesCount;
    private String selectedItemName;
    private LabeledTextField newMethodName;
    private Button checkQuery;

    public InlineLocalPage(InlineLocalConfig config, int occurencesCount, String selectedItemName) {
        super(String.valueOf(InlineLocalRefactoring.NAME) + "...");
        this.config = config;
        this.occurencesCount = occurencesCount;
        this.selectedItemName = selectedItemName;
    }

    public void pageIsEnabled() {
        super.pageIsEnabled();
        this.newMethodName.setEnabled(this.checkQuery.getSelection());
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        this.initPage(control);
    }

    private void initPage(Composite control) {
        GridLayout baseLayout = new GridLayout();
        baseLayout.numColumns = 1;
        baseLayout.verticalSpacing = 25;
        control.setLayout((Layout)baseLayout);
        this.initLabel(control);
        this.initExtractArea(control);
    }

    private void initExtractArea(Composite control) {
        Group queryGroup = this.initGroup(control);
        this.checkQuery = new Button((Composite)queryGroup, 32);
        this.checkQuery.setText(Messages.InlineTempPage_ReplaceTempWithQuery);
        this.checkQuery.setEnabled(true);
        this.newMethodName = new LabeledTextField((Composite)queryGroup, Messages.InlineTempPage_NewMethodName);
        GridData textData = new GridData(768);
        this.newMethodName.setLayoutData(textData);
        this.createSelectionListener(this.checkQuery, this.newMethodName);
        this.createModifyListener(this.newMethodName.getText());
    }

    private void createModifyListener(final Text newMethodName) {
        newMethodName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newName = newMethodName.getText();
                InlineLocalPage.this.config.setNewMethodName(newName);
                this.checkInput(newName);
            }

            private void checkInput(String newName) {
                if (NameValidator.isValidMethodName(newName)) {
                    InlineLocalPage.this.setMessage(null);
                    InlineLocalPage.this.setPageComplete(true);
                } else {
                    InlineLocalPage.this.setMessage("'" + newName + Messages.InlineTempPage_IsNotValidName, 3);
                    InlineLocalPage.this.setPageComplete(false);
                }
            }
        });
    }

    private void createSelectionListener(final Button checkQuery, final LabeledTextField newMethodName) {
        checkQuery.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean doReplaceTempWithQuery = checkQuery.getSelection();
                newMethodName.setEnabled(doReplaceTempWithQuery);
                InlineLocalPage.this.config.setReplaceTempWithQuery(doReplaceTempWithQuery);
                if (!doReplaceTempWithQuery) {
                    InlineLocalPage.this.setMessage(null);
                }
                InlineLocalPage.this.setPageComplete(!doReplaceTempWithQuery);
            }
        });
    }

    private Group initGroup(Composite control) {
        Group queryGroup = new Group(control, 0);
        queryGroup.setText(Messages.InlineTempPage_ExtractToMethod);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        groupLayout.verticalSpacing = 15;
        queryGroup.setLayout((Layout)groupLayout);
        GridData groupData = new GridData(768);
        queryGroup.setLayoutData((Object)groupData);
        return queryGroup;
    }

    private void initLabel(Composite control) {
        Label infoLabel = new Label(control, 0);
        infoLabel.setText(String.valueOf(Messages.InlineTempPage_Replace) + this.occurencesCount + Messages.InlineTempPage_Occurences + this.selectedItemName + "'.");
        GridData layoutData = new GridData(768);
        infoLabel.setLayoutData((Object)layoutData);
    }
}

