/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.renamemethod.NodeSelector;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.ui.RdtCodeViewer;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.util.JRubyRefactoringUtils;

public class OccurenceReplaceSelectionPage
extends RefactoringWizardPage {
    public static final String NAME = Messages.OccurenceReplaceSelectionPage_SelectCalls;
    private static final RGB highlightColor = new RGB(173, 193, 217);
    private NodeSelector selector;
    private Table possibilityTable;
    private IDocumentProvider docProvider;

    public OccurenceReplaceSelectionPage(NodeSelector selector, IDocumentProvider docProvider) {
        super(NAME);
        this.selector = selector;
        this.docProvider = docProvider;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        FillLayout controlLayout = new FillLayout();
        controlLayout.spacing = 10;
        controlLayout.marginHeight = 10;
        controlLayout.marginWidth = 10;
        control.setLayout((Layout)controlLayout);
        this.initPossibilityTable(control);
        this.initCodeView(control);
        this.setControl((Control)control);
    }

    private void initCodeView(Composite control) {
        final RdtCodeViewer viewer = RdtCodeViewer.create(control);
        this.possibilityTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                INodeWrapper currentCall = (INodeWrapper)e.item.getData();
                ISourcePosition pos = currentCall.getWrappedNode().getPosition();
                String file = OccurenceReplaceSelectionPage.this.docProvider.getFileContent(currentCall.getWrappedNode().getPosition().getFile());
                this.updateCodeViewer(viewer, pos, file);
                this.updateChecks();
            }

            private void updateCodeViewer(RdtCodeViewer viewer2, ISourcePosition pos, String content) {
                int length = pos.getEndOffset() - pos.getStartOffset();
                viewer2.setPreviewText(content);
                viewer2.setBackgroundColor(pos.getStartOffset(), length, highlightColor);
                viewer2.getTextWidget().setSelection(pos.getStartOffset());
                viewer2.getTextWidget().showSelection();
            }

            private void updateChecks() {
                ArrayList<INodeWrapper> checkedCalls = new ArrayList<INodeWrapper>();
                TableItem[] tableItemArray = OccurenceReplaceSelectionPage.this.possibilityTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem currentItem = tableItemArray[n2];
                    if (currentItem.getChecked()) {
                        checkedCalls.add((INodeWrapper)currentItem.getData());
                    }
                    ++n2;
                }
                OccurenceReplaceSelectionPage.this.selector.setSelectedCalls(checkedCalls);
            }
        });
    }

    private void initPossibilityTable(Composite control) {
        this.possibilityTable = new Table(control, 2080);
        TreeSet<INodeWrapper> possibleCalls = new TreeSet<INodeWrapper>(new Comparator<INodeWrapper>(){

            @Override
            public int compare(INodeWrapper left, INodeWrapper right) {
                return left.getWrappedNode().getPosition().getStartOffset() - right.getWrappedNode().getPosition().getStartOffset();
            }
        });
        possibleCalls.addAll(this.selector.getPossibleCalls());
        for (INodeWrapper currentCall : possibleCalls) {
            TableItem currentItem = new TableItem(this.possibilityTable, 0);
            currentItem.setText(this.getTableCaption(currentCall));
            if (this.probableCall(currentCall)) {
                currentItem.setChecked(true);
            }
            currentItem.setData((Object)currentCall);
        }
    }

    private String getTableCaption(INodeWrapper currentCall) {
        ISourcePosition pos = currentCall.getWrappedNode().getPosition();
        return String.valueOf(pos.getFile()) + Messages.OccurenceReplaceSelectionPage_Line + (pos.getStartLine() + 1);
    }

    private boolean probableCall(INodeWrapper currentCall) {
        for (INodeWrapper iNodeWrapper : this.selector.getSelectedCalls()) {
            if (!this.hasSamePosition(currentCall, iNodeWrapper)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSamePosition(INodeWrapper currentCall, INodeWrapper targetCall) {
        return JRubyRefactoringUtils.hasSamePosition(currentCall.getWrappedNode(), targetCall.getWrappedNode());
    }
}

