/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.extractmethod;

import java.util.Observable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.refactoring.core.extractmethod.MethodExtractor;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.IValidationController;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.Messages;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class MethodNameListener
extends Observable
implements ModifyListener {
    private final MethodExtractor extractor;
    private final IValidationController validationController;

    public MethodNameListener(MethodExtractor extractor, IValidationController validationController) {
        this.extractor = extractor;
        this.validationController = validationController;
    }

    public void modifyText(ModifyEvent e) {
        String name = ((Text)e.widget).getText();
        this.extractor.getExtractedMethod().setMethodName(name);
        this.checkInput(name);
        this.setChanged();
        this.notifyObservers(name);
    }

    private void checkInput(String name) {
        if (NameValidator.isValidMethodName(name)) {
            this.validationController.setError(null);
            this.validationController.setComplete(this, true);
        } else {
            this.validationController.setError(String.valueOf('\'') + name + Messages.MethodNameListener_IsNotValidName);
            this.validationController.setComplete(this, false);
        }
    }
}

