/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.extractmethod;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.widgets.Label;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodHelper;

public class SignatureObserver
implements Observer {
    private final Label signatureLabel;
    private final ExtractedMethodHelper methodHelper;

    public SignatureObserver(Label signatureLabel, ExtractedMethodHelper methodHelper) {
        this.signatureLabel = signatureLabel;
        this.methodHelper = methodHelper;
        this.setPreviewText();
    }

    public void update(Observable observable, Object object) {
        this.setPreviewText();
    }

    private void setPreviewText() {
        if ("".equals(this.methodHelper.getMethodName())) {
            return;
        }
        StringBuilder string = new StringBuilder("def " + this.methodHelper.getMethodName() + ' ');
        Iterator<String> it = this.methodHelper.getArguments().iterator();
        while (it.hasNext()) {
            string.append(it.next());
            if (!it.hasNext()) continue;
            string.append(", ");
        }
        this.signatureLabel.setText(string.toString());
    }
}

