/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.util;

import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.rubypeople.rdt.internal.formatter.OldCodeFormatter;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class HsrFormatter {
    public static String format(String document, String replaceText, int replaceStartOffset, int replaceEndOffset) {
        StringBuilder docStringBuilder = new StringBuilder(document);
        docStringBuilder.delete(replaceStartOffset, replaceEndOffset);
        return HsrFormatter.format(docStringBuilder.toString(), replaceText, replaceStartOffset);
    }

    public static String format(String document, String insertText, int insertOffset) {
        if (insertText.length() == 0) {
            return insertText;
        }
        String lineDelimiter = "\n";
        if (document.length() == 0) {
            return HsrFormatter.formatString(insertText, lineDelimiter);
        }
        StringBuilder docStringBuilder = new StringBuilder(document);
        insertText = String.valueOf(lineDelimiter) + insertText + lineDelimiter;
        if (insertOffset == document.length()) {
            docStringBuilder.append(insertText);
        } else {
            docStringBuilder.insert(insertOffset, insertText);
        }
        int end = insertOffset + insertText.length() - 1;
        int linesToSort = HsrFormatter.getLineCount(docStringBuilder.toString(), insertOffset += lineDelimiter.length(), end, lineDelimiter);
        int lnNr = HsrFormatter.getLnNr(docStringBuilder.toString(), insertOffset - 1, lineDelimiter);
        document = docStringBuilder.toString();
        String formattedDocument = HsrFormatter.formatString(document, lineDelimiter);
        String text = HsrFormatter.getSubstring(formattedDocument, lnNr, linesToSort, lineDelimiter);
        return text;
    }

    private static String formatString(String code, String lineDelimiter) {
        Document doc = new Document(code);
        try {
            HsrFormatter.getFormatter().format(0, code, 0, code.length(), 0, lineDelimiter).apply((IDocument)doc);
            return doc.get();
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static OldCodeFormatter getFormatter() {
        if (RubyPlugin.getDefault() != null) {
            return RubyPlugin.getDefault().getCodeFormatter();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.rubypeople.rdt.core.formatter.tabulation.char", "space");
        options.put("org.rubypeople.rdt.core.formatter.indentation.size", "2");
        options.put("org.rubypeople.rdt.core.formatter.tabulation.size", "2");
        return new OldCodeFormatter(options);
    }

    private static String getSubstring(String str, int lnNr, int lnCount, String lineDelimiter) {
        int start = -1;
        int stop = 0;
        int i = 0;
        while (i < lnNr) {
            start = str.indexOf(lineDelimiter, start + 1);
            ++i;
        }
        stop = ++start - 2;
        i = 0;
        while (i < lnCount) {
            int tmpStop = str.indexOf(lineDelimiter, stop + 1);
            if (tmpStop == -1) break;
            stop = tmpStop;
            ++i;
        }
        str = str.substring(start, stop);
        return str;
    }

    private static int getLineCount(String text, int offset, int end, String lineDelimiter) {
        int count = 0;
        int pos = offset - 1;
        while ((pos = text.indexOf(lineDelimiter, pos + 1)) <= end && pos != -1) {
            ++count;
        }
        return ++count;
    }

    private static int getLnNr(String text, int offset, String lineDelimiter) {
        return HsrFormatter.getLineCount(text, 0, offset, lineDelimiter) - 1;
    }
}

