/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallHierarchy;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodCall;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodReferencesSearchRequestor;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodWrapper;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

class CallerMethodWrapper
extends MethodWrapper {
    public CallerMethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        super(parent, methodCall);
    }

    protected IRubySearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    protected String getTaskName() {
        return CallHierarchyMessages.CallerMethodWrapper_taskname;
    }

    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CallerMethodWrapper(this, methodCall);
    }

    protected Map findChildren(IProgressMonitor progressMonitor) {
        try {
            MethodReferencesSearchRequestor searchRequestor = new MethodReferencesSearchRequestor();
            SearchEngine searchEngine = new SearchEngine();
            SubProgressMonitor monitor = new SubProgressMonitor(progressMonitor, 95, 2);
            IRubySearchScope defaultSearchScope = this.getSearchScope();
            boolean isWorkspaceScope = SearchEngine.createWorkspaceScope().equals(defaultSearchScope);
            Iterator iter = this.getMembers().iterator();
            while (iter.hasNext()) {
                this.checkCanceled(progressMonitor);
                IMember member = (IMember)iter.next();
                SearchPattern pattern = SearchPattern.createPattern((IRubyElement)member, (int)1, (int)24);
                IRubySearchScope searchScope = isWorkspaceScope ? this.getAccurateSearchScope(defaultSearchScope, member) : defaultSearchScope;
                searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)searchRequestor, (IProgressMonitor)monitor);
            }
            return searchRequestor.getCallers();
        }
        catch (CoreException e) {
            RubyPlugin.log(e);
            return new HashMap(0);
        }
    }

    private IRubySearchScope getAccurateSearchScope(IRubySearchScope defaultSearchScope, IMember member) throws RubyModelException {
        if (!member.isType(6) || !((IMethod)member).isPrivate()) {
            return defaultSearchScope;
        }
        if (member.getRubyScript() != null) {
            return SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[]{member.getRubyScript()});
        }
        return defaultSearchScope;
    }

    private Collection getMembers() {
        ArrayList<IMember> result = new ArrayList<IMember>();
        result.add(this.getMember());
        return result;
    }
}

